/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.service.impl.events;

import com.tc.management.ManagementEventListener;
import com.tc.management.RemoteManagement;
import com.tc.management.TCManagementEvent;
import com.tc.management.TSAManagementEventPayload;
import com.tc.management.TerracottaRemoteManagement;
import com.terracotta.management.service.impl.util.RemoteManagementSource;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.events.EventEntityV2;
import org.terracotta.management.resource.services.events.EventServiceV2;

public class EventServiceImplV2
implements EventServiceV2 {
    private static final Logger LOG = LoggerFactory.getLogger(EventServiceImplV2.class);
    private final Map<EventServiceV2.EventListener, ListenerHolder> listenerMap = new IdentityHashMap<EventServiceV2.EventListener, ListenerHolder>();
    private final RemoteManagementSource remoteManagementSource;

    public EventServiceImplV2(RemoteManagementSource remoteManagementSource) {
        this.remoteManagementSource = remoteManagementSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(final EventServiceV2.EventListener listener, boolean localOnly) {
        RemoteManagementSource.RemoteTSAEventListener remoteTSAEventListener = null;
        if (!localOnly) {
            remoteTSAEventListener = new RemoteManagementSource.RemoteTSAEventListener(){

                public void onEvent(InboundEvent inboundEvent) {
                    EventEntityV2 eventEntity = (EventEntityV2)inboundEvent.readData(EventEntityV2.class);
                    listener.onEvent(eventEntity);
                }

                public void onError(Throwable throwable) {
                    listener.onError(throwable);
                }
            };
            this.remoteManagementSource.addTsaEventListener(remoteTSAEventListener);
        }
        RemoteManagement remoteManagementInstance = TerracottaRemoteManagement.getRemoteManagementInstance();
        ManagementEventListener managementEventListener = new ManagementEventListener(){

            public ClassLoader getClassLoader() {
                return EventServiceImplV2.class.getClassLoader();
            }

            public void onEvent(TCManagementEvent event, Map<String, Object> context) {
                EventEntityV2 eventEntity;
                Serializable payload = event.getPayload();
                if (payload instanceof EventEntityV2) {
                    eventEntity = (EventEntityV2)payload;
                    String agentId = (String)context.get("CONTEXT_SOURCE_JMX_ID");
                    String clientID = (String)context.get("CONTEXT_SOURCE_NODE_NAME");
                    String remoteAddress = (String)context.get("CONTEXT_SOURCE_REMOTE_ADDRESS");
                    eventEntity.getRootRepresentables().put("RemoteAddress", remoteAddress);
                    eventEntity.getRootRepresentables().put("ClientID", clientID);
                    eventEntity.setAgentId(agentId);
                } else if (payload instanceof TSAManagementEventPayload) {
                    TSAManagementEventPayload tsaManagementEventPayload = (TSAManagementEventPayload)payload;
                    eventEntity = new EventEntityV2();
                    eventEntity.setAgentId("embedded");
                    eventEntity.getRootRepresentables().put("Server.Name", context.get("CONTEXT_SOURCE_NODE_NAME"));
                    eventEntity.getRootRepresentables().putAll(tsaManagementEventPayload.getAttributes());
                    eventEntity.setType(event.getType());
                } else {
                    eventEntity = new EventEntityV2();
                    eventEntity.setType("TSA.ERROR");
                    eventEntity.setAgentId("embedded");
                    eventEntity.getRootRepresentables().put("Error.Details", "Unknown event : " + payload);
                }
                listener.onEvent(eventEntity);
            }
        };
        Map<EventServiceV2.EventListener, ListenerHolder> map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.put(listener, new ListenerHolder(managementEventListener, remoteTSAEventListener));
        }
        remoteManagementInstance.registerEventListener(managementEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(EventServiceV2.EventListener listener) {
        ListenerHolder listenerHolder;
        Map<EventServiceV2.EventListener, ListenerHolder> map = this.listenerMap;
        synchronized (map) {
            listenerHolder = this.listenerMap.remove(listener);
        }
        if (listenerHolder != null) {
            RemoteManagement remoteManagementInstance = TerracottaRemoteManagement.getRemoteManagementInstance();
            remoteManagementInstance.unregisterEventListener(listenerHolder.managementEventListener);
            if (listenerHolder.remoteTSAEventListener != null) {
                this.remoteManagementSource.removeTsaEventListener(listenerHolder.remoteTSAEventListener);
            }
        }
    }

    static class ListenerHolder {
        ManagementEventListener managementEventListener;
        RemoteManagementSource.RemoteTSAEventListener remoteTSAEventListener;

        ListenerHolder(ManagementEventListener managementEventListener, RemoteManagementSource.RemoteTSAEventListener remoteTSAEventListener) {
            this.managementEventListener = managementEventListener;
            this.remoteTSAEventListener = remoteTSAEventListener;
        }
    }
}

