/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.service.impl;

import com.tc.config.schema.L2Info;
import com.tc.config.schema.ServerGroupInfo;
import com.tc.config.schema.setup.TopologyReloadStatus;
import com.tc.objectserver.api.BackupManager;
import com.tc.objectserver.api.GCStats;
import com.tc.operatorevent.TerracottaOperatorEvent;
import com.tc.operatorevent.TerracottaOperatorEventImpl;
import com.terracotta.management.resource.BackupEntityV2;
import com.terracotta.management.resource.ConfigEntityV2;
import com.terracotta.management.resource.LicenseEntityV2;
import com.terracotta.management.resource.LogEntityV2;
import com.terracotta.management.resource.MBeanEntityV2;
import com.terracotta.management.resource.OperatorEventEntityV2;
import com.terracotta.management.resource.ServerEntityV2;
import com.terracotta.management.resource.ServerGroupEntityV2;
import com.terracotta.management.resource.StatisticsEntityV2;
import com.terracotta.management.resource.ThreadDumpEntityV2;
import com.terracotta.management.resource.TopologyEntityV2;
import com.terracotta.management.resource.TopologyReloadStatusEntityV2;
import com.terracotta.management.security.SecurityContextService;
import com.terracotta.management.service.L1MBeansSource;
import com.terracotta.management.service.TimeoutService;
import com.terracotta.management.service.impl.util.L1MBeansSourceUtils;
import com.terracotta.management.service.impl.util.LocalManagementSource;
import com.terracotta.management.service.impl.util.ManagementSourceException;
import com.terracotta.management.service.impl.util.RemoteManagementSource;
import com.terracotta.management.web.proxy.ProxyException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.UriBuilder;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.AbstractEntityV2;
import org.terracotta.management.resource.ResponseEntityV2;

public class ServerManagementServiceV2
implements L1MBeansSource {
    private static final String[] SERVER_ENTITY_ATTRIBUTE_NAMES = new String[]{"Version", "BuildID", "DescriptionOfCapabilities", "PersistenceMode", "FailoverMode", "TSAListenPort", "TSAGroupPort", "InitialState", "State", "StartTime", "ActivateTime", "Restartable", "ResourceState"};
    private static final String[] SERVER_STATS_ATTRIBUTE_NAMES = new String[]{"LiveObjectCount", "ReadOperationRate", "WriteOperationRate", "OffheapMaxSize", "OffheapReservedSize", "OffheapUsedSize", "EvictionRate", "ExpirationRate", "StorageStats"};
    private final LocalManagementSource localManagementSource;
    private final ExecutorService executorService;
    private final TimeoutService timeoutService;
    private final RemoteManagementSource remoteManagementSource;
    private final SecurityContextService securityContextService;

    public ServerManagementServiceV2(ExecutorService executorService, TimeoutService timeoutService, LocalManagementSource localManagementSource, RemoteManagementSource remoteManagementSource, SecurityContextService securityContextService) {
        this.executorService = executorService;
        this.timeoutService = timeoutService;
        this.localManagementSource = localManagementSource;
        this.remoteManagementSource = remoteManagementSource;
        this.securityContextService = securityContextService;
    }

    public boolean isEnterpriseEdition() throws ServiceExecutionException {
        try {
            return this.localManagementSource.isEnterpriseEdition();
        }
        catch (ManagementSourceException e) {
            throw new ServiceExecutionException("error making JMX call", (Throwable)e);
        }
    }

    public Collection<String> getL2Urls() throws ServiceExecutionException {
        try {
            return this.localManagementSource.getServerUrls().values();
        }
        catch (ManagementSourceException e) {
            throw new ServiceExecutionException("error making JMX call", (Throwable)e);
        }
    }

    public ResponseEntityV2<ThreadDumpEntityV2> serversThreadDump(Set<String> serverNames) throws ServiceExecutionException {
        return this.forEachServer("serversThreadDump", serverNames, new ForEachServer<ThreadDumpEntityV2>(){

            @Override
            public Collection<ThreadDumpEntityV2> queryLocalServer(L2Info member) {
                ThreadDumpEntityV2 threadDumpEntityV2 = new ThreadDumpEntityV2();
                threadDumpEntityV2.setSourceId(member.name());
                threadDumpEntityV2.setNodeType(ThreadDumpEntityV2.NodeType.SERVER);
                try {
                    threadDumpEntityV2.setDump(ServerManagementServiceV2.this.localManagementSource.serverThreadDump());
                }
                catch (ManagementSourceException mse) {
                    threadDumpEntityV2.setDump("Unavailable");
                }
                return Collections.singleton(threadDumpEntityV2);
            }

            @Override
            public ResponseEntityV2<ThreadDumpEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("diagnostics").path("threadDump").path("servers").matrixParam("names", new Object[]{member.name()});
                try {
                    return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, ThreadDumpEntityV2.class);
                }
                catch (ProcessingException che) {
                    ResponseEntityV2 responseEntityV2 = new ResponseEntityV2();
                    ThreadDumpEntityV2 threadDumpEntityV2 = new ThreadDumpEntityV2();
                    threadDumpEntityV2.setSourceId(member.name());
                    threadDumpEntityV2.setNodeType(ThreadDumpEntityV2.NodeType.SERVER);
                    threadDumpEntityV2.setDump("Unavailable");
                    responseEntityV2.getEntities().add(threadDumpEntityV2);
                    return responseEntityV2;
                }
            }
        });
    }

    public ResponseEntityV2<StatisticsEntityV2> getServersStatistics(Set<String> serverNames, final Set<String> attributesToShow) throws ServiceExecutionException {
        final String[] mbeanAttributeNames = attributesToShow == null ? SERVER_STATS_ATTRIBUTE_NAMES : new ArrayList<String>(attributesToShow).toArray(new String[attributesToShow.size()]);
        return this.forEachServer("getServersStatistics", serverNames, new ForEachServer<StatisticsEntityV2>(){

            @Override
            public Collection<StatisticsEntityV2> queryLocalServer(L2Info member) {
                StatisticsEntityV2 statisticsEntityV2 = new StatisticsEntityV2();
                statisticsEntityV2.setSourceId(member.name());
                try {
                    statisticsEntityV2.getStatistics().putAll(ServerManagementServiceV2.this.localManagementSource.getDsoAttributes(mbeanAttributeNames));
                }
                catch (ManagementSourceException e) {
                    statisticsEntityV2.getStatistics().put("Error", e.getMessage());
                }
                return Collections.singleton(statisticsEntityV2);
            }

            @Override
            public ResponseEntityV2<StatisticsEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("statistics").path("servers").matrixParam("names", new Object[]{member.name()});
                if (attributesToShow != null) {
                    uriBuilder.queryParam("show", new Object[]{RemoteManagementSource.toCsv((Collection)attributesToShow)});
                }
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, StatisticsEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<StatisticsEntityV2> getDgcStatistics(Set<String> serverNames, int maxDgcStatsEntries) throws ServiceExecutionException {
        return this.forEachServer("getDgcStatistics", serverNames, maxDgcStatsEntries, new ForEachServer<StatisticsEntityV2>(){

            @Override
            public Collection<StatisticsEntityV2> queryLocalServer(L2Info member) {
                ArrayList<StatisticsEntityV2> localResult = new ArrayList<StatisticsEntityV2>();
                try {
                    GCStats[] attributes;
                    for (GCStats gcStat : attributes = ServerManagementServiceV2.this.localManagementSource.getGcStats()) {
                        StatisticsEntityV2 statisticsEntityV2 = new StatisticsEntityV2();
                        statisticsEntityV2.setSourceId(member.name());
                        statisticsEntityV2.getStatistics().put("Iteration", gcStat.getIteration());
                        statisticsEntityV2.getStatistics().put("ActualGarbageCount", gcStat.getActualGarbageCount());
                        statisticsEntityV2.getStatistics().put("BeginObjectCount", gcStat.getBeginObjectCount());
                        statisticsEntityV2.getStatistics().put("CandidateGarbageCount", gcStat.getCandidateGarbageCount());
                        statisticsEntityV2.getStatistics().put("ElapsedTime", gcStat.getElapsedTime());
                        statisticsEntityV2.getStatistics().put("EndObjectCount", gcStat.getEndObjectCount());
                        statisticsEntityV2.getStatistics().put("MarkStageTime", gcStat.getMarkStageTime());
                        statisticsEntityV2.getStatistics().put("PausedStageTime", gcStat.getPausedStageTime());
                        statisticsEntityV2.getStatistics().put("StartTime", gcStat.getStartTime());
                        statisticsEntityV2.getStatistics().put("Status", gcStat.getStatus());
                        statisticsEntityV2.getStatistics().put("Type", gcStat.getType());
                        localResult.add(statisticsEntityV2);
                    }
                }
                catch (ManagementSourceException e) {
                    StatisticsEntityV2 statisticsEntityV2 = new StatisticsEntityV2();
                    statisticsEntityV2.setSourceId(member.name());
                    statisticsEntityV2.getStatistics().put("Error", e.getMessage());
                    localResult.add(statisticsEntityV2);
                }
                return localResult;
            }

            @Override
            public ResponseEntityV2<StatisticsEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("statistics").path("dgc").matrixParam("serverNames", new Object[]{member.name()});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, StatisticsEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<ConfigEntityV2> getServerConfigs(Set<String> serverNames) throws ServiceExecutionException {
        return this.forEachServer("getServerConfigs", serverNames, new ForEachServer<ConfigEntityV2>(){

            @Override
            public Collection<ConfigEntityV2> queryLocalServer(L2Info member) {
                ConfigEntityV2 configEntityV2 = new ConfigEntityV2();
                configEntityV2.setSourceId(member.name());
                try {
                    configEntityV2.getAttributes().putAll(ServerManagementServiceV2.this.localManagementSource.getServerInfoAttributes());
                }
                catch (ManagementSourceException mse) {
                    configEntityV2.getAttributes().put("Error", mse.getMessage());
                }
                return Collections.singleton(configEntityV2);
            }

            @Override
            public ResponseEntityV2<ConfigEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("configurations").path("servers").matrixParam("names", new Object[]{member.name()});
                try {
                    return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, ConfigEntityV2.class);
                }
                catch (ProcessingException che) {
                    ResponseEntityV2 responseEntityV2 = new ResponseEntityV2();
                    ConfigEntityV2 configEntityV2 = new ConfigEntityV2();
                    configEntityV2.setSourceId(member.name());
                    configEntityV2.getAttributes().put("Error", che.getMessage());
                    responseEntityV2.getEntities().add(configEntityV2);
                    return responseEntityV2;
                }
            }
        });
    }

    public ResponseEntityV2<BackupEntityV2> getBackupsStatus(Set<String> serverNames) throws ServiceExecutionException {
        return this.forEachServer("getBackupsStatus", serverNames, new ForEachServer<BackupEntityV2>(){

            @Override
            public Collection<BackupEntityV2> queryLocalServer(L2Info member) {
                if (!ServerManagementServiceV2.this.localManagementSource.isActiveCoordinator()) {
                    return null;
                }
                ArrayList<BackupEntityV2> localResult = new ArrayList<BackupEntityV2>();
                Map backups = ServerManagementServiceV2.this.localManagementSource.getBackupStatuses();
                for (String name : backups.keySet()) {
                    String status = (String)backups.get(name);
                    BackupEntityV2 backupEntityV2 = new BackupEntityV2();
                    backupEntityV2.setSourceId(member.name());
                    backupEntityV2.setName(name);
                    backupEntityV2.setStatus(status);
                    if ("FAILED".equals(status)) {
                        backupEntityV2.setError(ServerManagementServiceV2.this.localManagementSource.getBackupFailureReason(name));
                    }
                    localResult.add(backupEntityV2);
                }
                return localResult;
            }

            @Override
            public ResponseEntityV2<BackupEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("backups").matrixParam("serverNames", new Object[]{member.name()});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, BackupEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<LicenseEntityV2> getLicenseProperties(Set<String> serverNames) throws ServiceExecutionException {
        return this.forEachServer("getLicenseProperties", serverNames, new ForEachServer<LicenseEntityV2>(){

            @Override
            public Collection<LicenseEntityV2> queryLocalServer(L2Info member) {
                LicenseEntityV2 licenseV2 = new LicenseEntityV2();
                licenseV2.setSourceId(member.name());
                licenseV2.setProperties(ServerManagementServiceV2.this.localManagementSource.getLicenseProperties());
                return Collections.singleton(licenseV2);
            }

            @Override
            public ResponseEntityV2<LicenseEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("licenseProperties").matrixParam("serverNames", new Object[]{member.name()});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, LicenseEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<LogEntityV2> getLogs(Set<String> serverNames, final Long sinceWhen) throws ServiceExecutionException {
        return this.forEachServer("getLogs", serverNames, new ForEachServer<LogEntityV2>(){

            @Override
            public Collection<LogEntityV2> queryLocalServer(L2Info member) {
                ArrayList<LogEntityV2> localResult = new ArrayList<LogEntityV2>();
                try {
                    Collection logNotifications = ServerManagementServiceV2.this.localManagementSource.getNotifications(sinceWhen);
                    for (Notification logNotification : logNotifications) {
                        LogEntityV2 logEntityV2 = new LogEntityV2();
                        logEntityV2.setSourceId(member.name());
                        logEntityV2.setMessage(logNotification.getMessage());
                        logEntityV2.setTimestamp(logNotification.getTimeStamp());
                        localResult.add(logEntityV2);
                    }
                }
                catch (Exception e) {
                    LogEntityV2 logEntityV2 = new LogEntityV2();
                    logEntityV2.setSourceId(member.name());
                    logEntityV2.setMessage(e.getMessage());
                    localResult.add(logEntityV2);
                }
                return localResult;
            }

            @Override
            public ResponseEntityV2<LogEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("logs").matrixParam("names", new Object[]{member.name()});
                if (sinceWhen != null) {
                    uriBuilder.matrixParam("sinceWhen", new Object[]{sinceWhen});
                }
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, LogEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<OperatorEventEntityV2> getOperatorEvents(Set<String> serverNames, final Long sinceWhen, final Set<String> acceptableTypes, final Set<String> acceptableLevels, final boolean read) throws ServiceExecutionException {
        return this.forEachServer("getOperatorEvents", serverNames, new ForEachServer<OperatorEventEntityV2>(){

            @Override
            public Collection<OperatorEventEntityV2> queryLocalServer(L2Info member) {
                ArrayList<OperatorEventEntityV2> localResult = new ArrayList<OperatorEventEntityV2>();
                try {
                    Collection operatorEvents = ServerManagementServiceV2.this.localManagementSource.getOperatorEvents(sinceWhen);
                    for (TerracottaOperatorEvent operatorEvent : operatorEvents) {
                        if (operatorEvent.isRead() && read || acceptableTypes != null && !acceptableTypes.contains(operatorEvent.getEventTypeAsString()) || acceptableLevels != null && !acceptableLevels.contains(operatorEvent.getEventLevelAsString())) continue;
                        OperatorEventEntityV2 operatorEventEntityV2 = new OperatorEventEntityV2();
                        operatorEventEntityV2.setSourceId(member.name());
                        operatorEventEntityV2.setMessage(operatorEvent.getEventMessage());
                        operatorEventEntityV2.setTimestamp(operatorEvent.getEventTime().getTime());
                        operatorEventEntityV2.setCollapseString(operatorEvent.getCollapseString());
                        operatorEventEntityV2.setEventSubsystem(operatorEvent.getEventSubsystemAsString());
                        operatorEventEntityV2.setEventType(operatorEvent.getEventTypeAsString());
                        operatorEventEntityV2.setEventLevel(operatorEvent.getEventLevelAsString());
                        operatorEventEntityV2.setRead(operatorEvent.isRead());
                        localResult.add(operatorEventEntityV2);
                    }
                }
                catch (Exception e) {
                    OperatorEventEntityV2 operatorEventEntityV2 = new OperatorEventEntityV2();
                    operatorEventEntityV2.setSourceId(member.name());
                    operatorEventEntityV2.setMessage(e.getMessage());
                    localResult.add(operatorEventEntityV2);
                }
                return localResult;
            }

            @Override
            public ResponseEntityV2<OperatorEventEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("operatorEvents").matrixParam("names", new Object[]{member.name()});
                if (sinceWhen != null) {
                    uriBuilder.queryParam("sinceWhen", new Object[]{sinceWhen});
                }
                if (acceptableTypes != null) {
                    uriBuilder.queryParam("eventTypes", new Object[]{RemoteManagementSource.toCsv((Collection)acceptableTypes)});
                }
                if (acceptableLevels != null) {
                    uriBuilder.queryParam("eventLevels", new Object[]{RemoteManagementSource.toCsv((Collection)acceptableLevels)});
                }
                uriBuilder.queryParam("filterOutRead", new Object[]{read});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, OperatorEventEntityV2.class);
            }
        });
    }

    public ResponseEntityV2<MBeanEntityV2> queryMBeans(Set<String> serverNames, final String query) throws ServiceExecutionException {
        return this.forEachServer("queryMBeans", serverNames, new ForEachServer<MBeanEntityV2>(){

            @Override
            public Collection<MBeanEntityV2> queryLocalServer(L2Info member) {
                ArrayList<MBeanEntityV2> localResult = new ArrayList<MBeanEntityV2>();
                try {
                    Set objectNames = ServerManagementServiceV2.this.localManagementSource.queryNames(query);
                    for (ObjectName objectName : objectNames) {
                        ArrayList<MBeanEntityV2.AttributeEntityV2> attributeEntities = new ArrayList<MBeanEntityV2.AttributeEntityV2>();
                        Map attributes = ServerManagementServiceV2.this.localManagementSource.getMBeanAttributeInfo(objectName);
                        for (Map.Entry entry : attributes.entrySet()) {
                            MBeanEntityV2.AttributeEntityV2 attributeEntityV2 = new MBeanEntityV2.AttributeEntityV2();
                            attributeEntityV2.setName((String)entry.getKey());
                            attributeEntityV2.setType((String)entry.getValue());
                            attributeEntities.add(attributeEntityV2);
                        }
                        MBeanEntityV2 mBeanEntityV2 = new MBeanEntityV2();
                        mBeanEntityV2.setSourceId(member.name());
                        mBeanEntityV2.setObjectName(objectName.toString());
                        mBeanEntityV2.setAttributes(attributeEntities.toArray(new MBeanEntityV2.AttributeEntityV2[attributeEntities.size()]));
                        localResult.add(mBeanEntityV2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return localResult;
            }

            @Override
            public ResponseEntityV2<MBeanEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("jmx").matrixParam("names", new Object[]{member.name()});
                if (query != null) {
                    uriBuilder.queryParam("q", new Object[]{query});
                }
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, MBeanEntityV2.class);
            }
        });
    }

    public Collection<ServerGroupEntityV2> getServerGroups(Set<String> serverNames) throws ServiceExecutionException {
        ServerGroupInfo[] serverGroupInfos;
        ArrayList<ServerGroupEntityV2> localServerGroupEntities = new ArrayList<ServerGroupEntityV2>();
        HashMap<String, Future<Collection<ServerGroupEntityV2>>> futures = new HashMap<String, Future<Collection<ServerGroupEntityV2>>>();
        for (ServerGroupInfo serverGroupInfo : serverGroupInfos = this.localManagementSource.getServerGroupInfos()) {
            L2Info[] members;
            ServerGroupEntityV2 serverGroupEntityV2 = new ServerGroupEntityV2();
            serverGroupEntityV2.setName(serverGroupInfo.name());
            serverGroupEntityV2.setId(Integer.valueOf(serverGroupInfo.id()));
            serverGroupEntityV2.setCoordinator(serverGroupInfo.isCoordinator());
            for (L2Info member : members = serverGroupInfo.members()) {
                if (serverNames != null && !serverNames.contains(member.name())) continue;
                if (member.name().equals(this.localManagementSource.getLocalServerName())) {
                    this.getServerGroups_local(localServerGroupEntities, serverGroupEntityV2, member);
                    continue;
                }
                this.getServerGroups_remote(futures, serverGroupInfo, member);
            }
        }
        try {
            HashMap<String, ServerGroupEntityV2> mergedResult = new HashMap<String, ServerGroupEntityV2>();
            Collection remoteServerGroupEntities = this.remoteManagementSource.collectEntitiesCollectionFromFutures(futures, this.timeoutService.getCallTimeout(), "getServerGroups", Integer.MAX_VALUE);
            for (ServerGroupEntityV2 serverGroupEntityV2 : this.remoteManagementSource.merge(localServerGroupEntities, remoteServerGroupEntities)) {
                ServerGroupEntityV2 existingSge = (ServerGroupEntityV2)mergedResult.get(serverGroupEntityV2.getName());
                if (existingSge == null) {
                    mergedResult.put(serverGroupEntityV2.getName(), serverGroupEntityV2);
                    continue;
                }
                existingSge.getServers().addAll(serverGroupEntityV2.getServers());
            }
            return mergedResult.values();
        }
        catch (Exception e) {
            throw new ServiceExecutionException("error executing remote getServerGroups", (Throwable)e);
        }
    }

    private void getServerGroups_remote(Map<String, Future<Collection<ServerGroupEntityV2>>> futures, final ServerGroupInfo serverGroupInfo, final L2Info member) {
        final SecurityContextService.SecurityContext context = this.securityContextService.getSecurityContext();
        Future<Collection<ServerGroupEntityV2>> future = this.executorService.submit(new Callable<Collection<ServerGroupEntityV2>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<ServerGroupEntityV2> call() throws Exception {
                ServerManagementServiceV2.this.securityContextService.setSecurityContext(context);
                try {
                    UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("topologies").path("servers").matrixParam("names", new Object[]{member.name()});
                    try {
                        ResponseEntityV2 resp = (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, TopologyEntityV2.class);
                        Set<ServerGroupEntityV2> set = Collections.singleton(ServerManagementServiceV2.findServerGroupEntityV2ContainingServerWithName(resp.getEntities(), member.name()));
                        return set;
                    }
                    catch (ProcessingException che) {
                        ServerGroupEntityV2 sgEntityV2 = new ServerGroupEntityV2();
                        sgEntityV2.setName(serverGroupInfo.name());
                        sgEntityV2.setCoordinator(serverGroupInfo.isCoordinator());
                        sgEntityV2.setId(Integer.valueOf(serverGroupInfo.id()));
                        ServerEntityV2 sEntityV2 = new ServerEntityV2();
                        sEntityV2.setProductVersion(ServerManagementServiceV2.this.localManagementSource.getVersion());
                        sEntityV2.getAttributes().put("Name", member.name());
                        sEntityV2.getAttributes().put("Host", member.host());
                        sEntityV2.getAttributes().put("ManagementPort", member.managementPort());
                        sEntityV2.getAttributes().put("HostAddress", member.safeGetHostAddress());
                        sgEntityV2.getServers().add(sEntityV2);
                        Set<ServerGroupEntityV2> set = Collections.singleton(sgEntityV2);
                        ServerManagementServiceV2.this.securityContextService.clearSecurityContext();
                        return set;
                    }
                }
                finally {
                    ServerManagementServiceV2.this.securityContextService.clearSecurityContext();
                }
            }
        });
        futures.put(member.name(), future);
    }

    private void getServerGroups_local(Collection<ServerGroupEntityV2> localServerGroupEntities, ServerGroupEntityV2 serverGroupEntityV2, L2Info member) {
        ServerEntityV2 serverEntityV2 = new ServerEntityV2();
        serverEntityV2.setProductVersion(this.localManagementSource.getVersion());
        serverEntityV2.getAttributes().put("Name", member.name());
        serverEntityV2.getAttributes().put("Host", member.host());
        serverEntityV2.getAttributes().put("ManagementPort", member.managementPort());
        serverEntityV2.getAttributes().put("HostAddress", member.safeGetHostAddress());
        serverEntityV2.getAttributes().putAll(this.localManagementSource.getServerAttributes(SERVER_ENTITY_ATTRIBUTE_NAMES));
        serverGroupEntityV2.getServers().add(serverEntityV2);
        localServerGroupEntities.add(serverGroupEntityV2);
    }

    private static ServerGroupEntityV2 findServerGroupEntityV2ContainingServerWithName(Collection<TopologyEntityV2> topologyEntities, String name) {
        for (TopologyEntityV2 topologyEntityV2 : topologyEntities) {
            Set serverGroupEntities = topologyEntityV2.getServerGroupEntities();
            for (ServerGroupEntityV2 serverGroupEntityV2 : serverGroupEntities) {
                Set servers = serverGroupEntityV2.getServers();
                for (ServerEntityV2 server : servers) {
                    if (!name.equals(server.getAttributes().get("Name"))) continue;
                    return serverGroupEntityV2;
                }
            }
        }
        return null;
    }

    public Map<String, Integer> getUnreadOperatorEventCount(Set<String> serverNames) throws ServiceExecutionException {
        Collection topologyEntities = this.forEachServer("getUnreadOperatorEventCount", serverNames, new ForEachServer<TopologyEntityV2>(){

            @Override
            public Collection<TopologyEntityV2> queryLocalServer(L2Info member) {
                TopologyEntityV2 topologyEntityV2 = new TopologyEntityV2();
                topologyEntityV2.getUnreadOperatorEventCount().putAll(ServerManagementServiceV2.this.localManagementSource.getUnreadOperatorEventCount());
                return Collections.singleton(topologyEntityV2);
            }

            @Override
            public ResponseEntityV2<TopologyEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("topologies").path("unreadOperatorEventCount").matrixParam("serverNames", new Object[]{member.name()});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.getFromRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, TopologyEntityV2.class);
            }
        }).getEntities();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (TopologyEntityV2 topologyEntityV2 : topologyEntities) {
            Map unreadOperatorEventCount = topologyEntityV2.getUnreadOperatorEventCount();
            for (Map.Entry entry : unreadOperatorEventCount.entrySet()) {
                String key = (String)entry.getKey();
                Integer value = (Integer)entry.getValue();
                Integer totalValue = (Integer)result.get(key);
                if (totalValue == null) {
                    totalValue = 0;
                }
                totalValue = totalValue + value;
                result.put(key, totalValue);
            }
        }
        return result;
    }

    public void runDgc(Set<String> serverNames) throws ServiceExecutionException {
        this.forEachServer("runDgc", serverNames, new ForEachServer<AbstractEntityV2>(){

            @Override
            public Collection<AbstractEntityV2> queryLocalServer(L2Info member) {
                if (!ServerManagementServiceV2.this.localManagementSource.isActiveCoordinator()) {
                    return null;
                }
                ServerManagementServiceV2.this.localManagementSource.runDgc();
                return null;
            }

            @Override
            public ResponseEntityV2<AbstractEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("diagnostics").path("dgc").matrixParam("serverNames", new Object[]{member.name()});
                ServerManagementServiceV2.this.remoteManagementSource.postToRemoteL2(member.name(), uriBuilder.build(new Object[0]));
                return null;
            }
        });
    }

    public void dumpClusterState(Set<String> serverNames) throws ServiceExecutionException {
        this.forEachServer("dumpClusterState", serverNames, new ForEachServer<AbstractEntityV2>(){

            @Override
            public Collection<AbstractEntityV2> queryLocalServer(L2Info member) {
                ServerManagementServiceV2.this.localManagementSource.dumpClusterState();
                return null;
            }

            @Override
            public ResponseEntityV2<AbstractEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("diagnostics").path("dumpClusterState").matrixParam("serverNames", new Object[]{member.name()});
                ServerManagementServiceV2.this.remoteManagementSource.postToRemoteL2(member.name(), uriBuilder.build(new Object[0]));
                return null;
            }
        });
    }

    public ResponseEntityV2<BackupEntityV2> backup(Set<String> serverNames, String givenBackupName) throws ServiceExecutionException {
        final String backupName = givenBackupName != null ? givenBackupName : "backup." + new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
        return this.forEachServer("backup", serverNames, new ForEachServer<BackupEntityV2>(){

            @Override
            public Collection<BackupEntityV2> queryLocalServer(L2Info member) {
                if (!ServerManagementServiceV2.this.localManagementSource.isActiveCoordinator()) {
                    return null;
                }
                BackupEntityV2 backupEntityV2 = new BackupEntityV2();
                backupEntityV2.setSourceId(member.name());
                backupEntityV2.setName(backupName);
                try {
                    ServerManagementServiceV2.this.localManagementSource.backup(backupName);
                    backupEntityV2.setStatus(ServerManagementServiceV2.this.localManagementSource.getBackupStatus(backupName));
                }
                catch (Exception e) {
                    backupEntityV2.setStatus(BackupManager.BackupStatus.FAILED.name());
                    backupEntityV2.setError(e.getMessage());
                }
                return Collections.singleton(backupEntityV2);
            }

            @Override
            public ResponseEntityV2<BackupEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("backups").matrixParam("serverNames", new Object[]{member.name()}).queryParam("name", new Object[]{backupName});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.postToRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, BackupEntityV2.class);
            }
        });
    }

    public void shutdownServers(Set<String> serverNames) throws ServiceExecutionException {
        final AtomicBoolean includeLocalServer = new AtomicBoolean(false);
        this.forEachServer("shutdownServers", serverNames, new ForEachServer<AbstractEntityV2>(){

            @Override
            public Collection<AbstractEntityV2> queryLocalServer(L2Info member) {
                includeLocalServer.set(true);
                return null;
            }

            @Override
            public ResponseEntityV2<AbstractEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("shutdown").matrixParam("names", new Object[]{member.name()});
                ServerManagementServiceV2.this.remoteManagementSource.postToRemoteL2(member.name(), uriBuilder.build(new Object[0]));
                return null;
            }
        });
        if (includeLocalServer.get()) {
            this.localManagementSource.shutdownServer();
        }
    }

    public boolean markOperatorEvent(OperatorEventEntityV2 operatorEventEntityV2, boolean read) throws ServiceExecutionException {
        String sourceId = operatorEventEntityV2.getSourceId();
        if (sourceId.equals(this.localManagementSource.getLocalServerName())) {
            TerracottaOperatorEventImpl terracottaOperatorEvent = new TerracottaOperatorEventImpl(TerracottaOperatorEvent.EventLevel.valueOf((String)operatorEventEntityV2.getEventLevel()), TerracottaOperatorEvent.EventSubsystem.valueOf((String)operatorEventEntityV2.getEventSubsystem()), TerracottaOperatorEvent.EventType.valueOf((String)operatorEventEntityV2.getEventType()), operatorEventEntityV2.getMessage(), operatorEventEntityV2.getTimestamp(), operatorEventEntityV2.getCollapseString());
            return this.localManagementSource.markOperatorEvent((TerracottaOperatorEvent)terracottaOperatorEvent, read);
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("operatorEvents");
        uriBuilder = read ? uriBuilder.path("read") : uriBuilder.path("unread");
        return (Boolean)this.remoteManagementSource.postToRemoteL2(sourceId, uriBuilder.build(new Object[0]), Collections.singleton(operatorEventEntityV2), Boolean.class);
    }

    public ResponseEntityV2<TopologyReloadStatusEntityV2> reloadConfiguration(Set<String> serverNames) throws ServiceExecutionException {
        return this.forEachServer("reloadConfiguration", serverNames, new ForEachServer<TopologyReloadStatusEntityV2>(){

            @Override
            public Collection<TopologyReloadStatusEntityV2> queryLocalServer(L2Info member) {
                TopologyReloadStatusEntityV2 topologyReloadStatusEntityV2 = new TopologyReloadStatusEntityV2();
                topologyReloadStatusEntityV2.setSourceId(member.name());
                try {
                    TopologyReloadStatus topologyReloadStatus = ServerManagementServiceV2.this.localManagementSource.reloadConfiguration();
                    topologyReloadStatusEntityV2.setStatus(topologyReloadStatus.name());
                }
                catch (ManagementSourceException e) {
                    topologyReloadStatusEntityV2.setStatus(e.getMessage());
                }
                return Collections.singleton(topologyReloadStatusEntityV2);
            }

            @Override
            public ResponseEntityV2<TopologyReloadStatusEntityV2> queryRemoteServer(L2Info member) throws Exception {
                UriBuilder uriBuilder = UriBuilder.fromPath((String)"tc-management-api").path("v2").path("agents").path("diagnostics").path("reloadConfiguration").matrixParam("serverNames", new Object[]{member.name()});
                return (ResponseEntityV2)ServerManagementServiceV2.this.remoteManagementSource.postToRemoteL2(member.name(), uriBuilder.build(new Object[0]), ResponseEntityV2.class, TopologyReloadStatusEntityV2.class);
            }
        });
    }

    private <T extends AbstractEntityV2> ResponseEntityV2<T> forEachServer(String methodName, Set<String> serverNames, ForEachServer<T> fes) throws ServiceExecutionException {
        return this.forEachServer(methodName, serverNames, Integer.MAX_VALUE, fes);
    }

    private <T extends AbstractEntityV2> ResponseEntityV2<T> forEachServer(String methodName, Set<String> serverNames, int maxEntries, final ForEachServer<T> fes) throws ServiceExecutionException {
        L2Info[] members;
        ResponseEntityV2 result = new ResponseEntityV2();
        HashMap futures = new HashMap();
        for (final L2Info member : members = this.localManagementSource.getL2Infos()) {
            if (serverNames != null && !serverNames.contains(member.name())) continue;
            if (member.name().equals(this.localManagementSource.getLocalServerName())) {
                Collection<T> c = fes.queryLocalServer(member);
                if (c == null) continue;
                result.getEntities().addAll(c);
                continue;
            }
            final SecurityContextService.SecurityContext context = this.securityContextService.getSecurityContext();
            Future future = this.executorService.submit(new Callable<ResponseEntityV2<T>>(){

                @Override
                public ResponseEntityV2<T> call() throws Exception {
                    ServerManagementServiceV2.this.securityContextService.setSecurityContext(context);
                    try {
                        ResponseEntityV2 responseEntityV2 = fes.queryRemoteServer(member);
                        return responseEntityV2;
                    }
                    finally {
                        ServerManagementServiceV2.this.securityContextService.clearSecurityContext();
                    }
                }
            });
            futures.put(member.name(), future);
        }
        try {
            Collection responseEntityV2s = this.remoteManagementSource.collectEntitiesFromFutures(futures, this.timeoutService.getCallTimeout(), methodName, maxEntries);
            for (ResponseEntityV2 remoteResponse : responseEntityV2s) {
                result.getEntities().addAll(remoteResponse.getEntities());
                result.getExceptionEntities().addAll(remoteResponse.getExceptionEntities());
            }
            return result;
        }
        catch (Exception e) {
            this.remoteManagementSource.cancelFutures(futures.values());
            throw new ServiceExecutionException("error executing remote " + methodName, (Throwable)e);
        }
    }

    public boolean containsJmxMBeans() {
        return this.localManagementSource.containsJmxMBeans();
    }

    public void proxyClientRequest() throws ProxyException, ServiceExecutionException {
        L1MBeansSourceUtils.proxyClientRequest((String)this.getActiveL2UrlContainingMBeans());
    }

    private String getActiveL2UrlContainingMBeans() throws ServiceExecutionException {
        String name = this.getActiveL2ContainingMBeansName();
        return name == null ? null : (String)this.localManagementSource.getServerUrls().get(name);
    }

    public String getActiveL2ContainingMBeansName() throws ServiceExecutionException {
        Collection<ServerGroupEntityV2> serverGroups = this.getServerGroups(null);
        for (ServerGroupEntityV2 serverGroup : serverGroups) {
            Set servers = serverGroup.getServers();
            for (ServerEntityV2 server : servers) {
                String status = (String)server.getAttributes().get("State");
                if (!"ACTIVE-COORDINATOR".equals(status) || !serverGroup.isCoordinator()) continue;
                return (String)server.getAttributes().get("Name");
            }
        }
        return null;
    }

    static interface ForEachServer<T extends AbstractEntityV2> {
        public Collection<T> queryLocalServer(L2Info var1);

        public ResponseEntityV2<T> queryRemoteServer(L2Info var1) throws Exception;
    }
}

