/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.service.impl;

import com.terracotta.management.resource.StatisticsEntityV2;
import com.terracotta.management.resource.services.utils.ProductIdConverter;
import com.terracotta.management.service.MonitoringServiceV2;
import com.terracotta.management.service.impl.ClientManagementServiceV2;
import com.terracotta.management.service.impl.ServerManagementServiceV2;
import java.net.URI;
import java.util.Set;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.ResponseEntityV2;

public class MonitoringServiceImplV2
implements MonitoringServiceV2 {
    private static final int MAX_DGC_STATS_ENTRIES = 1000;
    private final ServerManagementServiceV2 serverManagementService;
    private final ClientManagementServiceV2 clientManagementService;

    public MonitoringServiceImplV2(ServerManagementServiceV2 serverManagementService, ClientManagementServiceV2 clientManagementService) {
        this.serverManagementService = serverManagementService;
        this.clientManagementService = clientManagementService;
    }

    public ResponseEntityV2<StatisticsEntityV2> getClientStatistics(Set<String> clientIds, Set<String> attributes, Set<String> clientProductIds) throws ServiceExecutionException {
        return this.clientManagementService.getClientsStatistics(clientIds, ProductIdConverter.stringsToProductsIds(clientProductIds), attributes);
    }

    public ResponseEntityV2<StatisticsEntityV2> getServerStatistics(Set<String> serverNames, Set<String> attributes) throws ServiceExecutionException {
        return this.serverManagementService.getServersStatistics(serverNames, attributes);
    }

    public ResponseEntityV2<StatisticsEntityV2> getServerStatistics(Set<String> serverNames, Set<String> attributes, Set<String> agentIds, URI uri) throws ServiceExecutionException {
        return this.serverManagementService.getServersStatistics(serverNames, attributes);
    }

    public ResponseEntityV2<StatisticsEntityV2> getDgcStatistics(Set<String> serverNames) throws ServiceExecutionException {
        return this.serverManagementService.getDgcStatistics(serverNames, 1000);
    }
}

