/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.service.impl;

import com.terracotta.management.resource.LogEntityV2;
import com.terracotta.management.resource.services.utils.TimeStringParser;
import com.terracotta.management.service.LogsServiceV2;
import com.terracotta.management.service.impl.ServerManagementServiceV2;
import java.util.Set;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.ResponseEntityV2;

public class LogsServiceImplV2
implements LogsServiceV2 {
    private final ServerManagementServiceV2 serverManagementService;

    public LogsServiceImplV2(ServerManagementServiceV2 serverManagementService) {
        this.serverManagementService = serverManagementService;
    }

    public ResponseEntityV2<LogEntityV2> getLogs(Set<String> serverNames) throws ServiceExecutionException {
        return this.serverManagementService.getLogs(serverNames, null);
    }

    public ResponseEntityV2<LogEntityV2> getLogs(Set<String> serverNames, long sinceWhen) throws ServiceExecutionException {
        return this.serverManagementService.getLogs(serverNames, sinceWhen);
    }

    public ResponseEntityV2<LogEntityV2> getLogs(Set<String> serverNames, String sinceWhen) throws ServiceExecutionException {
        if (sinceWhen == null) {
            return this.getLogs(serverNames);
        }
        try {
            return this.getLogs(serverNames, TimeStringParser.parseTime((String)sinceWhen));
        }
        catch (NumberFormatException nfe) {
            throw new ServiceExecutionException("Illegal time string: [" + sinceWhen + "]", (Throwable)nfe);
        }
    }
}

