/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.service.impl;

import com.terracotta.management.resource.ThreadDumpEntityV2;
import com.terracotta.management.resource.TopologyReloadStatusEntityV2;
import com.terracotta.management.resource.services.utils.ProductIdConverter;
import com.terracotta.management.service.DiagnosticsServiceV2;
import com.terracotta.management.service.impl.ClientManagementServiceV2;
import com.terracotta.management.service.impl.ServerManagementServiceV2;
import java.util.Set;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.ResponseEntityV2;

public class DiagnosticsServiceImplV2
implements DiagnosticsServiceV2 {
    private final ServerManagementServiceV2 serverManagementService;
    private final ClientManagementServiceV2 clientManagementService;

    public DiagnosticsServiceImplV2(ServerManagementServiceV2 serverManagementService, ClientManagementServiceV2 clientManagementService) {
        this.serverManagementService = serverManagementService;
        this.clientManagementService = clientManagementService;
    }

    public ResponseEntityV2<ThreadDumpEntityV2> getClusterThreadDump(Set<String> clientProductIds) throws ServiceExecutionException {
        ResponseEntityV2<ThreadDumpEntityV2> responseEntityV2 = this.serverManagementService.serversThreadDump(null);
        responseEntityV2.getEntities().addAll(this.clientManagementService.clientsThreadDump(null, ProductIdConverter.stringsToProductsIds(clientProductIds)).getEntities());
        return responseEntityV2;
    }

    public ResponseEntityV2<ThreadDumpEntityV2> getServersThreadDump(Set<String> serverNames) throws ServiceExecutionException {
        return this.serverManagementService.serversThreadDump(serverNames);
    }

    public ResponseEntityV2<ThreadDumpEntityV2> getClientsThreadDump(Set<String> clientIds, Set<String> clientProductIds) throws ServiceExecutionException {
        return this.clientManagementService.clientsThreadDump(clientIds, ProductIdConverter.stringsToProductsIds(clientProductIds));
    }

    public boolean runDgc(Set<String> serverNames) throws ServiceExecutionException {
        this.serverManagementService.runDgc(serverNames);
        return true;
    }

    public boolean dumpClusterState(Set<String> serverNames) throws ServiceExecutionException {
        this.serverManagementService.dumpClusterState(serverNames);
        return true;
    }

    public ResponseEntityV2<TopologyReloadStatusEntityV2> reloadConfiguration(Set<String> serverNames) throws ServiceExecutionException {
        return this.serverManagementService.reloadConfiguration(serverNames);
    }
}

