/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services;

import com.terracotta.management.resource.ServerEntityV2;
import com.terracotta.management.resource.ServerGroupEntityV2;
import com.terracotta.management.resource.ServerStatEntityV2;
import com.terracotta.management.resource.TopologyEntityV2;
import com.terracotta.management.service.TopologyServiceV2;
import com.terracotta.management.service.impl.util.LocalManagementSource;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

@Path(value="/v2/local/stat")
public class ServerStatResourceServiceImplV2 {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStatResourceServiceImplV2.class);
    private final TopologyServiceV2 topologyService;
    private final LocalManagementSource localManagementSource = new LocalManagementSource();

    public ServerStatResourceServiceImplV2() {
        this.topologyService = (TopologyServiceV2)ServiceLocator.locate(TopologyServiceV2.class);
    }

    @GET
    @Produces(value={"application/json"})
    public ServerStatEntityV2 getServerStats(@Context UriInfo info) {
        LOG.debug(String.format("Invoking ServerStatResourceServiceImplV2.getServerStats: %s", info.getRequestUri()));
        try {
            ServerGroupEntityV2 currentServerGroup = this.getCurrentServerGroup();
            ServerEntityV2 currentServer = this.getCurrentServer(currentServerGroup);
            String health = "OK";
            String role = null;
            String initialState = null;
            String state = null;
            if (currentServer != null) {
                String string = role = currentServer.getAttributes().get("State").equals("ACTIVE-COORDINATOR") ? "ACTIVE" : "PASSIVE";
                if (this.localManagementSource.isWaitingForFailOverAction()) {
                    role = "WAITING-FOR-PROMOTION";
                }
                initialState = (String)currentServer.getAttributes().get("InitialState");
                state = (String)currentServer.getAttributes().get("State");
            }
            String managementPort = currentServer.getAttributes().get("ManagementPort").toString();
            String serverGroupName = currentServerGroup.getName();
            return new ServerStatEntityV2(health, role, initialState, state, managementPort, serverGroupName, this.localManagementSource.getLocalServerName());
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to get stats", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    private ServerEntityV2 getCurrentServer(ServerGroupEntityV2 currentServerGroup) throws ServiceExecutionException {
        String localServerName = this.localManagementSource.getLocalServerName();
        for (ServerEntityV2 server : currentServerGroup.getServers()) {
            if (!server.getAttributes().get("Name").equals(localServerName)) continue;
            return server;
        }
        return null;
    }

    private ServerGroupEntityV2 getCurrentServerGroup() throws ServiceExecutionException {
        String localServerName = this.localManagementSource.getLocalServerName();
        Collection serverTopologies = this.topologyService.getServerTopologies(null).getEntities();
        for (TopologyEntityV2 serverTopology : serverTopologies) {
            Set serverGroups = serverTopology.getServerGroupEntities();
            for (ServerGroupEntityV2 serverGroup : serverGroups) {
                Set servers = serverGroup.getServers();
                for (ServerEntityV2 server : servers) {
                    if (!server.getAttributes().get("Name").equals(localServerName)) continue;
                    return serverGroup;
                }
            }
        }
        return null;
    }
}

