/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.beans.TCServerInfoMBean;
import com.tc.management.beans.UnexpectedStateException;
import com.terracotta.management.resource.ServerEntityV2;
import com.terracotta.management.resource.ServerGroupEntityV2;
import com.terracotta.management.resource.StopEntityV2;
import com.terracotta.management.resource.TopologyEntityV2;
import com.terracotta.management.service.TopologyServiceV2;
import com.terracotta.management.service.impl.util.LocalManagementSource;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;

@Path(value="/v2/local/shutdown")
public class LocalShutdownResourceServiceImplV2 {
    private static final TCLogger LOG = TCLogging.getLogger(LocalShutdownResourceServiceImplV2.class);
    private final TopologyServiceV2 topologyService;
    private final LocalManagementSource localManagementSource = new LocalManagementSource();

    public LocalShutdownResourceServiceImplV2() {
        this.topologyService = (TopologyServiceV2)ServiceLocator.locate(TopologyServiceV2.class);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response shutdown(@Context UriInfo info, StopEntityV2 stopConfig) {
        LOG.info((Object)String.format("Invoking shutdown: %s", info.getRequestUri()));
        try {
            if (stopConfig != null && !stopConfig.isForceStop() && !this.isPassiveStandbyAvailable() && this.localManagementSource.isLegacyProductionModeEnabled()) {
                String errorMessage = "No passive server available in Standby mode. Use force option to stop the server.";
                LOG.debug((Object)errorMessage);
                throw new ResourceRuntimeException(errorMessage, Response.Status.BAD_REQUEST.getStatusCode());
            }
        }
        catch (ServiceExecutionException see) {
            throw new ResourceRuntimeException("Failed to shutdown TSA", (Throwable)see, Response.Status.BAD_REQUEST.getStatusCode());
        }
        boolean stopIfPassive = false;
        boolean stopIfActive = false;
        TCServerInfoMBean.RestartMode restartMode = TCServerInfoMBean.RestartMode.STOP_ONLY;
        if (stopConfig != null) {
            stopIfActive = stopConfig.isStopIfActive();
            stopIfPassive = stopConfig.isStopIfPassive();
            if (stopConfig.isRestart()) {
                restartMode = TCServerInfoMBean.RestartMode.STOP_AND_RESTART;
            } else if (stopConfig.isRestartInSafeMode()) {
                restartMode = TCServerInfoMBean.RestartMode.STOP_AND_RESTART_IN_SAFE_MODE;
            }
        }
        try {
            if (stopIfActive) {
                this.localManagementSource.shutdownServerIfActive(restartMode);
            } else if (stopIfPassive) {
                this.localManagementSource.shutdownServerIfPassive(restartMode);
            } else {
                this.localManagementSource.shutdownServer(restartMode);
            }
        }
        catch (UnexpectedStateException e) {
            return Response.ok((Object)false).build();
        }
        return Response.ok((Object)true).build();
    }

    private boolean isPassiveStandbyAvailable() throws ServiceExecutionException {
        ServerGroupEntityV2 currentServerGroup = this.getCurrentServerGroup();
        if (currentServerGroup == null) {
            return false;
        }
        for (ServerEntityV2 serverEntity : currentServerGroup.getServers()) {
            if (!"PASSIVE-STANDBY".equals(serverEntity.getAttributes().get("State"))) continue;
            return true;
        }
        return false;
    }

    private ServerGroupEntityV2 getCurrentServerGroup() throws ServiceExecutionException {
        String localServerName = this.localManagementSource.getLocalServerName();
        Collection serverTopologies = this.topologyService.getServerTopologies(null).getEntities();
        for (TopologyEntityV2 serverTopology : serverTopologies) {
            Set serverGroups = serverTopology.getServerGroupEntities();
            for (ServerGroupEntityV2 serverGroup : serverGroups) {
                Set servers = serverGroup.getServers();
                for (ServerEntityV2 server : servers) {
                    if (!server.getAttributes().get("Name").equals(localServerName)) continue;
                    return serverGroup;
                }
            }
        }
        return null;
    }
}

