/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.resource.services;

import com.tc.config.schema.setup.FailOverAction;
import com.tc.l2.state.sbp.InvalidOperationException;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.terracotta.management.service.FailOverServiceV2;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.terracotta.management.ServiceLocator;

@Path(value="/v2/local/failover")
public class FailOverResourceServiceImplV2 {
    private static final TCLogger logger = TCLogging.getLogger(FailOverResourceServiceImplV2.class);
    private final FailOverServiceV2 failOverService = (FailOverServiceV2)ServiceLocator.locate(FailOverServiceV2.class);

    @POST
    @Path(value="/promote")
    @Produces(value={"application/json"})
    public Response promote() {
        return this.performFailOverAction(FailOverAction.PROMOTE);
    }

    @POST
    @Path(value="/restart")
    @Produces(value={"application/json"})
    public Response restart() {
        return this.performFailOverAction(FailOverAction.RESTART);
    }

    @POST
    @Path(value="/failFast")
    @Produces(value={"application/json"})
    public Response failFast() {
        return this.performFailOverAction(FailOverAction.FAILFAST);
    }

    private Response performFailOverAction(FailOverAction action) {
        logger.info((Object)("Performing " + action + " fail-over action"));
        try {
            switch (action) {
                case PROMOTE: {
                    this.failOverService.promote();
                    break;
                }
                case RESTART: {
                    this.failOverService.restart();
                    break;
                }
                case FAILFAST: {
                    this.failOverService.failFast();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported fail-over action:" + action);
                }
            }
            return Response.ok().build();
        }
        catch (InvalidOperationException ioe) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ioe.getMessage()).build();
        }
    }
}

