/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.l1bridge;

import com.terracotta.management.l1bridge.RemoteCallerV2;
import com.terracotta.management.l1bridge.RemoteRequestValidator;
import com.terracotta.management.security.ContextService;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.UserService;
import com.terracotta.management.service.L1MBeansSource;
import com.terracotta.management.service.RemoteAgentBridgeService;
import com.terracotta.management.service.TimeoutService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.ErrorEntity;
import org.terracotta.management.resource.ResponseEntityV2;

public class RemoteServiceStubGeneratorV2 {
    private final RemoteCallerV2 remoteCaller;
    private final RemoteRequestValidator requestValidator;
    private final L1MBeansSource l1MBeansSource;

    public RemoteServiceStubGeneratorV2(RequestTicketMonitor requestTicketMonitor, UserService userService, ContextService contextService, RemoteRequestValidator requestValidator, RemoteAgentBridgeService remoteAgentBridgeService, ExecutorService executorService, TimeoutService timeoutService, L1MBeansSource l1MBeansSource) {
        this.requestValidator = requestValidator;
        this.l1MBeansSource = l1MBeansSource;
        this.remoteCaller = new RemoteCallerV2(remoteAgentBridgeService, contextService, executorService, requestTicketMonitor, userService, timeoutService);
    }

    public <T> T newRemoteService(Class<T> clazz, String agency) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(clazz.getName(), agency));
    }

    private final class RemoteInvocationHandler
    implements InvocationHandler {
        private final String serviceName;
        private final String agency;

        private RemoteInvocationHandler(String serviceName, String agency) {
            this.serviceName = serviceName;
            this.agency = agency;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (RemoteServiceStubGeneratorV2.this.l1MBeansSource.containsJmxMBeans()) {
                return this.invokeOnLocalServer(method, args);
            }
            RemoteServiceStubGeneratorV2.this.l1MBeansSource.proxyClientRequest();
            return null;
        }

        private Object invokeOnLocalServer(Method method, Object[] args) throws ServiceExecutionException {
            Set nodes = RemoteServiceStubGeneratorV2.this.requestValidator.getValidatedNodes();
            if (nodes == null) {
                throw new RuntimeException("Request has not been validated which prevents it from being bridged to the L1s. Bug?");
            }
            if (nodes.isEmpty()) {
                ErrorEntity errorEntity = new ErrorEntity();
                errorEntity.setError("No connected client");
                errorEntity.setDetails("No L1 to send the request to, try again later.");
                throw new WebApplicationException(Response.status((int)404).entity((Object)errorEntity).build());
            }
            if (ResponseEntityV2.class.isAssignableFrom(method.getReturnType())) {
                return RemoteServiceStubGeneratorV2.this.remoteCaller.fanOutResponseCall(this.agency, nodes, this.serviceName, method, args);
            }
            String node = RemoteServiceStubGeneratorV2.this.requestValidator.getSingleValidatedNode();
            return RemoteServiceStubGeneratorV2.this.remoteCaller.call(node, this.serviceName, method, args);
        }
    }
}

