/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.l1bridge;

import com.tc.properties.TCPropertiesImpl;
import com.terracotta.management.l1bridge.RejectionFuture;
import com.terracotta.management.l1bridge.RemoteCaller;
import com.terracotta.management.security.ContextService;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.UserService;
import com.terracotta.management.service.RemoteAgentBridgeService;
import com.terracotta.management.service.TimeoutService;
import com.terracotta.management.web.utils.TSAConfig;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.l1bridge.RemoteCallDescriptor;
import org.terracotta.management.resource.AbstractEntityV2;
import org.terracotta.management.resource.ExceptionEntityV2;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.exceptions.ExceptionUtils;

public class RemoteCallerV2
extends RemoteCaller {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCallerV2.class);

    public RemoteCallerV2(RemoteAgentBridgeService remoteAgentBridgeService, ContextService contextService, ExecutorService executorService, RequestTicketMonitor ticketMonitor, UserService userService, TimeoutService timeoutService) {
        super(remoteAgentBridgeService, contextService, executorService, ticketMonitor, userService, timeoutService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractEntityV2> ResponseEntityV2<T> fanOutResponseCall(final String serviceAgency, Set<String> nodes, final String serviceName, final Method method, final Object[] args) throws ServiceExecutionException {
        final Object userInfo = this.contextService.getUserInfo();
        HashMap futures = new HashMap();
        long beforeSubmission = System.nanoTime();
        for (final String node : nodes) {
            if (node.equals("embedded")) continue;
            try {
                Future future = this.executorService.submit(new Callable<ResponseEntityV2<T>>(){

                    @Override
                    public ResponseEntityV2<T> call() throws Exception {
                        String nodeAgency;
                        String ticket = RemoteCallerV2.this.requestTicketMonitor.issueRequestTicket();
                        String token = RemoteCallerV2.this.userService.putUserInfo(userInfo);
                        if (serviceAgency != null && !serviceAgency.equals(nodeAgency = RemoteCallerV2.this.remoteAgentBridgeService.getRemoteAgentAgency(node))) {
                            return new ResponseEntityV2();
                        }
                        RemoteCallDescriptor remoteCallDescriptor = new RemoteCallDescriptor(ticket, token, TSAConfig.getSecurityCallbackUrl(), serviceName, method.getName(), (Class[])method.getParameterTypes(), args);
                        byte[] bytes = RemoteCallerV2.this.remoteAgentBridgeService.invokeRemoteMethod(node, remoteCallDescriptor);
                        return (ResponseEntityV2)RemoteCallerV2.this.deserializeAndRewriteAgentId(bytes, node);
                    }
                });
                futures.put(node, future);
            }
            catch (RejectedExecutionException ree) {
                ResponseEntityV2 rejectionResponse = new ResponseEntityV2();
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ree);
                ExceptionEntityV2 ee = new ExceptionEntityV2(rootCause);
                ee.setAgentId(node);
                rejectionResponse.getExceptionEntities().add(ee);
                futures.put(node, new RejectionFuture<ResponseEntityV2>(rejectionResponse));
            }
        }
        long submissionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeSubmission);
        LOG.debug("fan-out call submission time : {}ms", (Object)submissionTime);
        if (submissionTime > this.timeoutService.getCallTimeout() / 2L) {
            LOG.warn("Slow L1 management fan-out call submission detected ({}ms), is the JMX thread pool saturated? Try increasing the 'l2.remotejmx.maxthreads' TC server property (current value is {})", (Object)submissionTime, (Object)TCPropertiesImpl.getProperties().getInt("l2.remotejmx.maxthreads"));
        }
        long timeLeft = Math.max(this.timeoutService.getCallTimeout() - submissionTime, 0L);
        ResponseEntityV2 globalResult = new ResponseEntityV2();
        for (Map.Entry entry : futures.entrySet()) {
            String node = (String)entry.getKey();
            Future future = (Future)entry.getValue();
            long beforeCollection = System.nanoTime();
            long timeout = Math.max(1L, timeLeft);
            try {
                ResponseEntityV2 resp = (ResponseEntityV2)future.get(timeout, TimeUnit.MILLISECONDS);
                globalResult.getEntities().addAll(resp.getEntities());
                globalResult.getExceptionEntities().addAll(resp.getExceptionEntities());
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                ExceptionEntityV2 e1 = new ExceptionEntityV2(rootCause);
                e1.setAgentId(node);
                globalResult.getExceptionEntities().add(e1);
                future.cancel(true);
                if (!(e instanceof TimeoutException)) continue;
                LOG.debug("Future execution error in   {}.{} : agent '{}' failed to respond to call in {}ms", new Object[]{serviceName, method.getName(), node, timeout, e});
            }
            finally {
                timeLeft -= TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - beforeCollection);
            }
        }
        return globalResult;
    }

    protected void rewriteAgentId(Object obj, String agentId) {
        if (obj instanceof ResponseEntityV2) {
            ResponseEntityV2 entityV2 = (ResponseEntityV2)obj;
            for (AbstractEntityV2 abstractEntityV2 : entityV2.getEntities()) {
                abstractEntityV2.setAgentId(agentId);
            }
            for (ExceptionEntityV2 exceptionEntityV2 : entityV2.getExceptionEntities()) {
                exceptionEntityV2.setAgentId(agentId);
            }
        } else {
            super.rewriteAgentId(obj, agentId);
        }
    }
}

