/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.l1bridge;

import com.terracotta.management.l1bridge.RemoteCallerV2;
import com.terracotta.management.security.ContextService;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.UserService;
import com.terracotta.management.service.L1MBeansSource;
import com.terracotta.management.service.RemoteAgentBridgeService;
import com.terracotta.management.service.TimeoutService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.AgentEntityV2;
import org.terracotta.management.resource.AgentMetadataEntityV2;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.services.AgentServiceV2;

public class RemoteAgentServiceV2
implements AgentServiceV2 {
    private final L1MBeansSource l1MBeansSource;
    private final RemoteCallerV2 remoteCaller;

    public RemoteAgentServiceV2(RemoteAgentBridgeService remoteAgentBridgeService, ContextService contextService, ExecutorService executorService, RequestTicketMonitor ticketMonitor, UserService userService, TimeoutService timeoutService, L1MBeansSource l1MBeansSource) {
        this.l1MBeansSource = l1MBeansSource;
        this.remoteCaller = new RemoteCallerV2(remoteAgentBridgeService, contextService, executorService, ticketMonitor, userService, timeoutService);
    }

    public ResponseEntityV2<AgentMetadataEntityV2> getAgentsMetadata(Set<String> ids) throws ServiceExecutionException {
        if (!this.l1MBeansSource.containsJmxMBeans()) {
            this.l1MBeansSource.proxyClientRequest();
            return null;
        }
        ResponseEntityV2 result = new ResponseEntityV2();
        Set nodes = this.remoteCaller.getRemoteAgentNodeNames();
        if (ids.isEmpty()) {
            ids = new HashSet<String>(nodes);
        }
        HashSet<String> unknownIds = new HashSet<String>(ids);
        unknownIds.removeAll(nodes);
        if (!unknownIds.isEmpty()) {
            throw new ServiceExecutionException("Unknown agent IDs : " + unknownIds);
        }
        try {
            ResponseEntityV2 fanOutCollectionCall = this.remoteCaller.fanOutResponseCall(null, nodes, AgentServiceV2.class.getName(), AgentServiceV2.class.getMethod("getAgentsMetadata", Set.class), new Object[]{Collections.emptySet()});
            result.getEntities().addAll(fanOutCollectionCall.getEntities());
            result.getExceptionEntities().addAll(fanOutCollectionCall.getExceptionEntities());
        }
        catch (NoSuchMethodException nsme) {
            throw new ServiceExecutionException("Error executing remote call", (Throwable)nsme);
        }
        return result;
    }

    public ResponseEntityV2<AgentEntityV2> getAgents(Set<String> idSet) throws ServiceExecutionException {
        if (!this.l1MBeansSource.containsJmxMBeans()) {
            this.l1MBeansSource.proxyClientRequest();
            return null;
        }
        ResponseEntityV2 result = new ResponseEntityV2();
        Map nodes = this.remoteCaller.getRemoteAgentNodeDetails();
        if (idSet.isEmpty()) {
            idSet = nodes.keySet();
        }
        for (String id : idSet) {
            if (!nodes.keySet().contains(id)) {
                throw new ServiceExecutionException("Unknown agent ID : " + id);
            }
            Map props = (Map)nodes.get(id);
            AgentEntityV2 entityV2 = new AgentEntityV2();
            entityV2.setAgentId(id);
            entityV2.setAgencyOf((String)props.get("Agency"));
            entityV2.getRootRepresentables().putAll(props);
            entityV2.getRootRepresentables().remove("Agency");
            result.getEntities().add(entityV2);
        }
        return result;
    }
}

