/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.embedded;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.servlet.ServletContainer;
import org.terracotta.management.embedded.FilterDetail;
import org.terracotta.management.embedded.StandaloneServerInterface;

public final class StandaloneServer
implements StandaloneServerInterface {
    public static final String EMBEDDED_CTXT = "/tc-management-api";
    private final List<FilterDetail> filterDetails;
    private final List<ServletContextListener> servletListeners;
    private volatile Server server;
    private final String applicationClassName;
    private final String host;
    private final int port;
    private final SSLContext sslCtxt;
    private final boolean needClientAuth;

    public StandaloneServer(List<FilterDetail> filterDetails, List<ServletContextListener> servletListeners, String applicationClassName, String host, int port, SSLContext sslCtxt, boolean needClientAuth) {
        this.filterDetails = filterDetails;
        this.servletListeners = servletListeners;
        this.applicationClassName = applicationClassName;
        this.host = host;
        this.port = port;
        this.sslCtxt = sslCtxt;
        this.needClientAuth = needClientAuth;
    }

    public void start() throws Exception {
        if (this.port < 0) {
            return;
        }
        if (this.port == 0) {
            throw new IllegalArgumentException("port must be set");
        }
        if (this.applicationClassName == null) {
            throw new IllegalArgumentException("applicationClassName must be set");
        }
        if (this.server != null) {
            throw new IllegalStateException("server already started");
        }
        try {
            ServerConnector connector;
            this.server = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.port);
            if (this.sslCtxt != null) {
                HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
                SecureRequestCustomizer src = new SecureRequestCustomizer();
                src.setSniHostCheck(false);
                httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setSslContext(this.sslCtxt);
                sslContextFactory.setNeedClientAuth(this.needClientAuth);
                connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig)});
            } else {
                connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            }
            connector.setHost(this.host);
            connector.setPort(this.port);
            this.server.setConnectors(new Connector[]{connector});
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath(EMBEDDED_CTXT);
            this.server.setHandler((Handler)context);
            ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer());
            servletHolder.setInitParameter("com.sun.jersey.config.feature.XmlRootElementProcessing", "true");
            servletHolder.setInitParameter("javax.ws.rs.Application", this.applicationClassName);
            servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", "com.sun.jersey.api.container.filter.GZIPContentEncodingFilter");
            servletHolder.setInitParameter("com.sun.jersey.spi.container.ContainerResponseFilters", "com.sun.jersey.api.container.filter.GZIPContentEncodingFilter");
            context.addServlet(servletHolder, "/*");
            if (this.servletListeners != null) {
                context.setEventListeners(Collections.unmodifiableList(this.servletListeners));
            }
            if (this.filterDetails != null) {
                for (FilterDetail f : this.filterDetails) {
                    FilterHolder filterHolder = new FilterHolder(f.getFilter());
                    EnumSet<DispatcherType> dTypes = null;
                    if (f.getDispatcherNames() != null) {
                        dTypes = EnumSet.noneOf(DispatcherType.class);
                        for (String dn : f.getDispatcherNames()) {
                            dTypes.add(DispatcherType.valueOf((String)dn));
                        }
                    }
                    context.addFilter(filterHolder, f.getPathSpec(), dTypes);
                }
            }
            this.server.start();
        }
        catch (Exception e) {
            this.server.stop();
            this.server = null;
            throw e;
        }
    }

    public void stop() throws Exception {
        if (this.server == null || this.port < 0) {
            return;
        }
        try {
            this.server.stop();
            this.server.join();
        }
        finally {
            this.server = null;
        }
    }
}

