/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services.validator;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.services.validator.AbstractEhcacheRequestValidator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractEhcacheRequestValidatorTest {
    @Test
    public void validateCacheManagerRequestSegmentTest_v1() {
        AbstractEhcacheRequestValidatorExtension abstractEhcacheRequestValidator = new AbstractEhcacheRequestValidatorExtension();
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        PathSegment pathSegmentAgents = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegmentAgents.getPath()).thenReturn((Object)"agents");
        PathSegment pathSegmentCacheManagers = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegmentCacheManagers.getPath()).thenReturn((Object)"cacheManagers");
        pathSegments.add(pathSegmentAgents);
        pathSegments.add(pathSegmentCacheManagers);
        Assert.assertEquals((Object)pathSegmentCacheManagers, (Object)abstractEhcacheRequestValidator.getCacheManagerPathSegmentAccordingToVersion(pathSegments));
    }

    @Test
    public void validateCacheManagerRequestSegmentTest_v2() {
        AbstractEhcacheRequestValidatorExtension abstractEhcacheRequestValidator = new AbstractEhcacheRequestValidatorExtension();
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        PathSegment pathSegmentVersion = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegmentVersion.getPath()).thenReturn((Object)"v2");
        PathSegment pathSegmentAgents = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegmentAgents.getPath()).thenReturn((Object)"agents");
        PathSegment pathSegmentCacheManagers = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegmentCacheManagers.getPath()).thenReturn((Object)"cacheManagers");
        pathSegments.add(pathSegmentVersion);
        pathSegments.add(pathSegmentAgents);
        pathSegments.add(pathSegmentCacheManagers);
        Assert.assertEquals((Object)pathSegmentCacheManagers, (Object)abstractEhcacheRequestValidator.getCacheManagerPathSegmentAccordingToVersion(pathSegments));
    }

    private final class AbstractEhcacheRequestValidatorExtension
    extends AbstractEhcacheRequestValidator {
        private AbstractEhcacheRequestValidatorExtension() {
        }

        public void validateSafe(UriInfo info) {
        }

        protected void validateAgentSegment(List<PathSegment> pathSegments) {
        }
    }
}

