/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services.utils;

import com.terracotta.management.resource.services.utils.UriInfoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class UriInfoUtilsTest {
    @Test
    public void testExtractProductIds_noProductIdReturnsNull() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getQueryParameters()).thenReturn((Object)new MultivaluedHashMap());
        Set strings = UriInfoUtils.extractProductIds((UriInfo)uriInfo);
        Assert.assertThat((Object)strings, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testExtractProductIds_returnSpecifiedProductIds() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getQueryParameters()).thenReturn((Object)new MultivaluedHashMap<String, String>(){
            {
                this.put("productIds", Arrays.asList("TMS,USER"));
            }
        });
        Set strings = UriInfoUtils.extractProductIds((UriInfo)uriInfo);
        Assert.assertThat((Object)strings.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)strings.containsAll(Arrays.asList("USER", "TMS")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExtractProductIds_wildcardReturnsAll() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getQueryParameters()).thenReturn((Object)new MultivaluedHashMap<String, String>(){
            {
                this.put("productIds", Arrays.asList("*"));
            }
        });
        Set strings = UriInfoUtils.extractProductIds((UriInfo)uriInfo);
        Assert.assertThat((Object)strings.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)strings.containsAll(Arrays.asList("TMS", "WAN", "USER")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExtractAgentIds_returnsIdsWhenPresent() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("v5000"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("agents", (MultivaluedMap<String, String>)new MultivaluedHashMap<String, String>(){
            {
                this.put("ids", Arrays.asList("value11,value12"));
            }
        }));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set strings = UriInfoUtils.extractAgentIds((UriInfo)uriInfo);
        Assert.assertThat((Object)strings.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)strings.containsAll(Arrays.asList("value11", "value12")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExtractAgentIds_returnsEmptySetWhenNotPresent() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("v5000"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("agents"));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set strings = UriInfoUtils.extractAgentIds((UriInfo)uriInfo);
        Assert.assertThat((Object)strings.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testExtractAgentIds_throwsWhenNoAgentsPath() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("v5000"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("noAgents"));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        try {
            UriInfoUtils.extractAgentIds((UriInfo)uriInfo);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExtractLastSegmentMatrixParameterAsSetAllowsBothMultivalueAndCsv() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("path1"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("path2", (MultivaluedMap<String, String>)new MultivaluedHashMap<String, String>(){
            {
                this.put("param1", Arrays.asList("value11,value12", "value21,value22"));
                this.put("param2", Arrays.asList("valueAA,valueAB,valueBA,valueBB"));
                this.put("param3", Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB"));
            }
        }));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set params = UriInfoUtils.extractLastSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"param1");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("value11", "value12", "value21", "value22")), (Matcher)Is.is((Object)true));
        params = UriInfoUtils.extractLastSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"param2");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB")), (Matcher)Is.is((Object)true));
        params = UriInfoUtils.extractLastSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"param3");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExtractLastSegmentMatrixParameterAsSetNoParam() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("path1"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("path2"));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set params = UriInfoUtils.extractLastSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"param1");
        Assert.assertThat((Object)params, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testExtractSegmentMatrixParameterAsSetAllowsBothMultivalueAndCsv() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("path1"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("path2", (MultivaluedMap<String, String>)new MultivaluedHashMap<String, String>(){
            {
                this.put("param1", Arrays.asList("value11,value12", "value21,value22"));
                this.put("param2", Arrays.asList("valueAA,valueAB,valueBA,valueBB"));
                this.put("param3", Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB"));
            }
        }));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set params = UriInfoUtils.extractSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"path2", (String)"param1");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("value11", "value12", "value21", "value22")), (Matcher)Is.is((Object)true));
        params = UriInfoUtils.extractSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"path2", (String)"param2");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB")), (Matcher)Is.is((Object)true));
        params = UriInfoUtils.extractSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"path2", (String)"param3");
        Assert.assertThat((Object)params.size(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)params.containsAll(Arrays.asList("valueAA", "valueAB", "valueBA", "valueBB")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testExtractSegmentMatrixParameterAsSetNoParam() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("path1"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("path2"));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set params = UriInfoUtils.extractSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"path1", (String)"param1");
        Assert.assertThat((Object)params, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testExtractSegmentMatrixParameterAsSetNoPath() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>();
        pathSegments.add(UriInfoUtilsTest.pathSegment("path1"));
        pathSegments.add(UriInfoUtilsTest.pathSegment("path2"));
        Mockito.when((Object)uriInfo.getPathSegments()).thenReturn(pathSegments);
        Set params = UriInfoUtils.extractSegmentMatrixParameterAsSet((UriInfo)uriInfo, (String)"path3", (String)"param1");
        Assert.assertThat((Object)params, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    private static PathSegment pathSegment(String path, MultivaluedMap<String, String> matrixParams) {
        PathSegment pathSegment = (PathSegment)Mockito.mock(PathSegment.class);
        Mockito.when((Object)pathSegment.getPath()).thenReturn((Object)path);
        Mockito.when((Object)pathSegment.getMatrixParameters()).thenReturn(matrixParams);
        return pathSegment;
    }

    private static PathSegment pathSegment(String path) {
        return UriInfoUtilsTest.pathSegment(path, (MultivaluedMap<String, String>)new MultivaluedHashMap());
    }
}

