/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.FileUtils;

public class JerseyApplicationTestCommon {
    protected static final String[] PACKAGE_STARTS_WITH_FILTERS = new String[]{"java", "javax", "org.apache", "com.sun", "org.codehaus", "org.hibernate", "org.glassfish.jersey", "com.fasterxml.jackson"};
    private static final ClassFilter JERSEY_FILTER = new ClassFilter(){

        @Override
        public boolean accept(Class<?> clazz) {
            return clazz.isAnnotationPresent(Provider.class) || clazz.isAnnotationPresent(Path.class);
        }
    };

    protected Set<Class<?>> annotatedClassesFound() throws IOException, ClassNotFoundException {
        List<String> classpathElements = this.getClasspathElements();
        HashSet jerseyAnnotatedClasses = new HashSet();
        for (String cpElement : classpathElements) {
            if (cpElement.endsWith(".jar")) {
                System.out.println("last scanned jar : " + cpElement);
                jerseyAnnotatedClasses.addAll(this.filterAnnotatedClassesFromJar(cpElement));
                continue;
            }
            System.out.println("last scanned path : " + cpElement);
            jerseyAnnotatedClasses.addAll(this.filterAnnotatedClassesFromDirectory(cpElement));
        }
        return jerseyAnnotatedClasses;
    }

    private List<String> getClasspathElements() throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        String classpath = System.getProperty("java.class.path");
        System.out.println("XXX Current classpath: " + classpath);
        if (classpath.contains("surefirebooter")) {
            JarFile surefireBooter = new JarFile(classpath);
            Manifest manifest = surefireBooter.getManifest();
            classpath = manifest.getMainAttributes().getValue("Class-path");
            surefireBooter.close();
            for (String urlElement : classpath.split(" ")) {
                elements.add(FileUtils.toFile((URL)new URL(urlElement)).getAbsolutePath());
            }
        } else {
            for (String path : classpath.split(File.pathSeparator)) {
                elements.add(path);
            }
        }
        return elements;
    }

    private Set<Class<?>> filterAnnotatedClassesFromDirectory(String cpElement) throws ClassNotFoundException {
        File[] files;
        HashSet classes = new HashSet();
        File rootPath = new File(cpElement);
        for (File file : files = rootPath.listFiles()) {
            this.filterAnnotatedClassesFromRootPath(file, classes, rootPath);
        }
        return classes;
    }

    private Set<Class<?>> filterAnnotatedClassesFromJar(String cpElement) throws IOException {
        HashSet classes = new HashSet();
        JarFile jarFile = new JarFile(cpElement);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            try {
                Class<?> clazz;
                if (!JerseyApplicationTestCommon.packageOfClassNotFiltered(className) || !JERSEY_FILTER.accept(clazz = Class.forName(className))) continue;
                classes.add(clazz);
            }
            catch (Throwable throwable) {}
        }
        jarFile.close();
        return classes;
    }

    private static boolean packageOfClassNotFiltered(String className) {
        for (String filter : PACKAGE_STARTS_WITH_FILTERS) {
            if (!className.startsWith(filter)) continue;
            return false;
        }
        return true;
    }

    protected static Set<Class<?>> filterClassesFromJaxRSPackages(Set<Class<?>> classesToFilter) {
        HashSet filteredClasses = new HashSet();
        for (Class<?> classTofilter : classesToFilter) {
            if (!JerseyApplicationTestCommon.packageOfClassNotFiltered(classTofilter.getName())) continue;
            filteredClasses.add(classTofilter);
        }
        return filteredClasses;
    }

    private void filterAnnotatedClassesFromRootPath(File file, Set<Class<?>> classes, File rootPath) throws ClassNotFoundException {
        File[] listOfFiles;
        if (file.isFile() && file.getAbsolutePath().endsWith(".class")) {
            String replace = file.getAbsolutePath().replace(rootPath.getAbsolutePath() + File.separator, "");
            String className = replace.replace(File.separator, ".").substring(0, replace.length() - 6);
            try {
                Class<?> clazz = Class.forName(className);
                if (JERSEY_FILTER.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable throwable) {}
        } else if (file.isDirectory() && (listOfFiles = file.listFiles()) != null) {
            for (File listOfFile : listOfFiles) {
                this.filterAnnotatedClassesFromRootPath(listOfFile, classes, rootPath);
            }
        }
    }

    private static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

