/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.DistributedObjectClient;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ClientShutdownManager.class);
    private final Set<Runnable> beforeShutdown = new HashSet<Runnable>();
    private final DistributedObjectClient client;

    public ClientShutdownManager(DistributedObjectClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.add(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.remove(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBeforeShutdownHooks() {
        Runnable[] runnableArray = this.beforeShutdown;
        synchronized (this.beforeShutdown) {
            Runnable[] beforeShutdowns = this.beforeShutdown.toArray(new Runnable[this.beforeShutdown.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Runnable runnable : beforeShutdowns) {
                runnable.run();
            }
            return;
        }
    }

    public void execute() {
        this.executeBeforeShutdownHooks();
        this.client.shutdownResources();
    }
}

