/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.transaction;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.transaction.TransactionAction;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionHandleImpl;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;

class TransactionCommitAction
implements TransactionAction {
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            TransactionHandleImpl handle = TransactionHandleImpl.withByteBuffers(buffers);
            boolean emptyTransaction = ByteBufferUtils.get(buffers) == 1;
            return new TransactionCommitAction(handle, emptyTransaction);
        }
    };
    private final TransactionHandle handle;
    private final boolean emptyTransaction;

    TransactionCommitAction(TransactionHandle handle, boolean emptyTransaction) {
        this.handle = handle;
        this.emptyTransaction = emptyTransaction;
    }

    @Override
    public TransactionHandle getHandle() {
        return this.handle;
    }

    @Override
    public boolean isCommit() {
        return true;
    }

    @Override
    public boolean isBegin() {
        return this.emptyTransaction;
    }

    @Override
    public void record(long lsn) {
    }

    @Override
    public void replay(long lsn) {
    }

    @Override
    public ByteBuffer[] getPayload(ActionCodec codec) {
        ByteBuffer handleBuffer = this.handle.toByteBuffer();
        ByteBuffer header = ByteBuffer.allocate(1);
        if (this.emptyTransaction) {
            header.put((byte)1);
        } else {
            header.put((byte)0);
        }
        header.flip();
        return new ByteBuffer[]{handleBuffer, header};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionCommitAction that = (TransactionCommitAction)o;
        return this.handle.equals(that.getHandle()) && this.emptyTransaction == that.emptyTransaction;
    }

    public int hashCode() {
        return this.handle != null ? this.handle.hashCode() : 0;
    }

    public String toString() {
        return "TransactionCommitAction{handle=" + this.handle + '}';
    }
}

