/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.log.LSNEventListener;
import com.terracottatech.frs.log.LogRecord;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LogRecordImpl
implements LogRecord {
    private long lsn;
    private ByteBuffer[] payload;
    private final LSNEventListener listener;

    public LogRecordImpl(ByteBuffer[] buffers, LSNEventListener listener) {
        this.payload = buffers;
        this.listener = listener;
    }

    @Override
    public long getLsn() {
        return this.lsn;
    }

    @Override
    public ByteBuffer[] getPayload() {
        ByteBuffer[] bufs = new ByteBuffer[this.payload.length];
        for (int x = 0; x < this.payload.length; ++x) {
            bufs[x] = this.payload[x].asReadOnlyBuffer();
        }
        return bufs;
    }

    @Override
    public void updateLsn(long lsn) {
        this.lsn = lsn;
        if (this.listener != null) {
            this.listener.record(lsn);
        }
    }

    public String toString() {
        return "LogRecordImpl{lsn=" + this.lsn + '}';
    }

    @Override
    public void close() throws IOException {
        this.payload = null;
    }
}

