/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.AbstractChunk;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.Loadable;
import com.terracottatech.frs.io.WrappingChunk;
import com.terracottatech.frs.io.nio.AbstractReadbackStrategy;
import com.terracottatech.frs.io.nio.ChannelOpener;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseBufferReadbackStrategy
extends AbstractReadbackStrategy
implements Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReadbackStrategy.class);
    protected static final ByteBuffer[] EMPTY = new ByteBuffer[0];
    private final FileChannel channel;
    private final BufferSource source;
    private final AtomicInteger outchunks = new AtomicInteger();
    private final ChannelOpener opener;
    private volatile boolean closeRequested = false;
    private volatile long lastKey = Long.MIN_VALUE;
    private volatile boolean sealed = false;

    BaseBufferReadbackStrategy(Direction dir, FileChannel channel, BufferSource source, ChannelOpener opener) throws IOException {
        this.channel = channel;
        this.source = source;
        this.opener = opener;
    }

    @Override
    public boolean isConsistent() {
        return this.sealed;
    }

    @Override
    public long getMaximumMarker() {
        return this.lastKey;
    }

    protected void seal(boolean consistent, long lastKey) {
        if (this.sealed) {
            throw new AssertionError((Object)"already sealed");
        }
        this.lastKey = lastKey;
        this.sealed = consistent;
    }

    protected void addChunk(Chunk c) throws IOException {
        if (!this.channel.isOpen()) {
            throw new IOException("file closed");
        }
        this.outchunks.incrementAndGet();
    }

    protected FileChannel getChannel() {
        return this.channel;
    }

    protected void removeChunk(Chunk c) throws IOException {
        if (this.outchunks.decrementAndGet() == 0 && this.closeRequested) {
            if (this.opener != null) {
                this.opener.close();
            } else {
                this.channel.close();
            }
        }
    }

    protected ByteBuffer readFully(int amount, ByteBuffer get) throws IOException {
        get.mark();
        get.limit(get.position() + amount);
        while (get.hasRemaining()) {
            this.channel.read(get);
        }
        get.reset();
        return get;
    }

    protected long readFullyFromPos(int amount, ByteBuffer get, long position) throws IOException {
        get.mark();
        get.limit(get.position() + amount);
        this.readDirectLoop(position, get);
        get.reset();
        return position + (long)amount;
    }

    protected ByteBuffer readDirect(long position, ByteBuffer get) throws IOException {
        get.mark();
        this.readDirectLoop(position, get);
        get.reset();
        return get;
    }

    private ByteBuffer readDirectLoop(long position, ByteBuffer get) throws IOException {
        int read = 0;
        while (get.hasRemaining()) {
            int amt = this.channel.read(get, position + (long)read);
            if (amt < 0) {
                throw new EOFException();
            }
            read += amt;
        }
        return get;
    }

    protected int writeDirect(long position, ByteBuffer get) throws IOException {
        throw new UnsupportedOperationException("read only");
    }

    protected ByteBuffer readVirtualDirect(long positon, ByteBuffer get) {
        try {
            return this.readDirect(positon, get);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected ByteBuffer allocate(int size) {
        if (size == 0) {
            throw new AssertionError();
        }
        if (this.source == null) {
            return ByteBuffer.allocate(size);
        }
        return this.source.getBuffer(size);
    }

    protected void free(ByteBuffer buf) {
        if (this.source != null && buf != null) {
            this.source.returnBuffer(buf);
        }
    }

    protected int writeVirtualDirect(long positon, ByteBuffer put) {
        try {
            return this.writeDirect(positon, put);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public void close() throws IOException {
        this.closeRequested = true;
        if (this.outchunks.get() == 0) {
            if (this.opener != null) {
                this.opener.close();
            } else {
                this.channel.close();
            }
        }
    }

    private static abstract class CloseableChunk
    extends AbstractChunk
    implements Closeable {
        private CloseableChunk() {
        }
    }

    protected class VirtualChunk
    implements Chunk,
    Closeable,
    Loadable {
        private final long offset;
        private long length = Long.MAX_VALUE;
        private long position = 0L;
        private boolean loaded = false;
        private ByteBuffer cache;
        private AtomicInteger loadedouts;
        private volatile boolean closed = false;

        public VirtualChunk(long offset) throws IOException {
            this.offset = offset;
            this.register();
            this.findLength();
        }

        public VirtualChunk(long offset, long len) throws IOException {
            this.offset = offset;
            this.length = len;
            this.position = 12L;
            this.register();
        }

        private void findLength() throws IOException {
            Chunk header = this.getChunk(12L);
            try {
                int cs = header.getInt();
                if (!SegmentHeaders.CHUNK_START.validate(cs)) {
                    throw new AssertionError((Object)"not valid");
                }
                this.length = header.getLong() + 12L;
                if (this.length > Integer.MAX_VALUE) {
                    throw new IOException("buffer overflow");
                }
            }
            finally {
                if (header instanceof Closeable) {
                    ((Closeable)((Object)header)).close();
                }
            }
        }

        @Override
        public void load() throws IOException {
            if (!this.loaded) {
                BaseBufferReadbackStrategy.this.free(this.cache);
                this.cache = BaseBufferReadbackStrategy.this.readDirect(this.offset, BaseBufferReadbackStrategy.this.allocate((int)this.length));
                this.cache.position((int)this.position);
                this.loaded = true;
                this.loadedouts = new AtomicInteger(1);
            }
        }

        private void register() throws IOException {
            BaseBufferReadbackStrategy.this.addChunk(this);
        }

        private ByteBuffer cache(int size) {
            if (this.cache == null) {
                this.cache = BaseBufferReadbackStrategy.this.allocate(32);
            }
            if (size < this.cache.capacity()) {
                this.cache.clear().limit(size);
                return this.cache;
            }
            return ByteBuffer.allocate(size);
        }

        public void setLength(long length) {
            this.length = length;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.loaded || this.loadedouts.decrementAndGet() == 0) {
                BaseBufferReadbackStrategy.this.free(this.cache);
            }
            BaseBufferReadbackStrategy.this.removeChunk(this);
        }

        @Override
        public ByteBuffer[] getBuffers() {
            if (this.loaded) {
                this.cache.position((int)this.position).limit((int)this.length);
                return new ByteBuffer[]{this.cache};
            }
            return null;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public long remaining() {
            return this.length - this.position;
        }

        @Override
        public void limit(long v) {
        }

        @Override
        public boolean hasRemaining() {
            return this.remaining() > 0L;
        }

        @Override
        public byte get(long pos) {
            if (this.loaded) {
                return this.cache.get((int)pos);
            }
            ByteBuffer buffer = BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + pos, this.cache(1));
            return buffer.get();
        }

        @Override
        public short getShort(long pos) {
            if (this.loaded) {
                return this.cache.getShort((int)pos);
            }
            ByteBuffer buffer = BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + pos, this.cache(2));
            return buffer.getShort();
        }

        @Override
        public int getInt(long pos) {
            if (this.loaded) {
                return this.cache.getInt((int)pos);
            }
            ByteBuffer buffer = BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + pos, this.cache(4));
            return buffer.getInt();
        }

        @Override
        public long getLong(long pos) {
            if (this.loaded) {
                return this.cache.getLong((int)pos);
            }
            ByteBuffer buffer = BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + pos, this.cache(8));
            return buffer.getLong();
        }

        @Override
        public byte get() {
            return this.get(this.position++);
        }

        @Override
        public void put(byte v) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public byte peek() {
            return this.get(this.position);
        }

        @Override
        public long getLong() {
            try {
                long l = this.getLong(this.position);
                return l;
            }
            finally {
                this.position += 8L;
            }
        }

        @Override
        public void putLong(long v) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public long peekLong() {
            return this.getLong(this.position);
        }

        @Override
        public short getShort() {
            try {
                short s = this.getShort(this.position);
                return s;
            }
            finally {
                this.position += 2L;
            }
        }

        @Override
        public void putShort(short v) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public short peekShort() {
            return this.getShort(this.position);
        }

        @Override
        public int getInt() {
            try {
                int n = this.getInt(this.position);
                return n;
            }
            finally {
                this.position += 4L;
            }
        }

        @Override
        public void putInt(int v) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public int peekInt() {
            return this.getInt(this.position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get(byte[] buf) {
            int read = 0;
            try {
                if (this.loaded) {
                    this.cache.position((int)this.position);
                    this.cache.get(buf);
                } else {
                    ByteBuffer wrapped = ByteBuffer.wrap(buf);
                    if ((long)wrapped.capacity() > this.length - this.position) {
                        wrapped.limit((int)(this.length - this.position));
                    }
                    read = BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + this.position, wrapped).remaining();
                }
            }
            finally {
                this.position += (long)read;
            }
            return read;
        }

        @Override
        public int put(byte[] buf) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public void skip(long jump) {
            if (this.position + jump > this.length) {
                throw new RuntimeException("pos:" + this.position + " len:" + this.length + " mov:" + jump);
            }
            this.position += jump;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer[] getBuffers(long size) {
            if (this.position + size > this.length) {
                throw new RuntimeException("pos:" + this.position + " len:" + this.length + " mov:" + size);
            }
            if (size == 0L) {
                ByteBuffer[] byteBufferArray = EMPTY;
                return byteBufferArray;
            }
            if (this.loaded) {
                this.cache.position((int)this.position).limit((int)(this.position + size));
                ByteBuffer[] byteBufferArray = new ByteBuffer[]{this.cache.slice()};
                return byteBufferArray;
            }
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{BaseBufferReadbackStrategy.this.readVirtualDirect(this.offset + this.position, BaseBufferReadbackStrategy.this.allocate((int)size))};
            return byteBufferArray;
            {
                finally {
                    this.cache.clear();
                }
            }
            finally {
                this.position += size;
            }
        }

        @Override
        public Chunk getChunk(long size) {
            try {
                if (this.position + size > this.length) {
                    throw new RuntimeException("pos:" + this.position + " len:" + this.length + " mov:" + size);
                }
                if (size == 0L) {
                    WrappingChunk wrappingChunk = new WrappingChunk(EMPTY);
                    return wrappingChunk;
                }
                if (this.loaded) {
                    this.loadedouts.incrementAndGet();
                    this.cache.position((int)this.position).limit((int)(this.position + size));
                    final ByteBuffer[] base = new ByteBuffer[]{this.cache.slice()};
                    this.cache.clear();
                    CloseableChunk closeableChunk = new CloseableChunk(){
                        boolean localclosed = false;

                        @Override
                        public ByteBuffer[] getBuffers() {
                            return base;
                        }

                        @Override
                        public void close() throws IOException {
                            if (this.localclosed) {
                                return;
                            }
                            this.localclosed = true;
                            if (VirtualChunk.this.loadedouts.decrementAndGet() == 0 && VirtualChunk.this.closed) {
                                BaseBufferReadbackStrategy.this.free(VirtualChunk.this.cache);
                            }
                        }
                    };
                    return closeableChunk;
                }
                FullChunk base = new FullChunk(this.offset + this.position, size);
                return base;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                this.position += size;
            }
        }

        @Override
        public void flip() {
        }

        @Override
        public void clear() {
            this.position = 0L;
        }

        public String toString() {
            return "VirtualChunk{offset=" + this.offset + ", length=" + this.length + ", position=" + this.position + ", closed=" + this.closed + '}';
        }
    }

    private class FullChunk
    extends AbstractChunk
    implements Closeable {
        private final ByteBuffer[] data;
        private volatile boolean closed = false;
        private final AtomicInteger openCount = new AtomicInteger(1);

        public FullChunk(long offset, long size) throws IOException {
            this.data = size == 0L ? EMPTY : new ByteBuffer[]{BaseBufferReadbackStrategy.this.readVirtualDirect(offset, BaseBufferReadbackStrategy.this.allocate((int)size))};
            this.register();
        }

        private void register() throws IOException {
            BaseBufferReadbackStrategy.this.addChunk(this);
        }

        @Override
        public ByteBuffer[] getBuffers() {
            return this.data;
        }

        @Override
        public Chunk getChunk(long size) {
            final ByteBuffer[] sub = this.getBuffers(size);
            final FullChunk parent = this;
            return new CloseableChunk(){
                volatile boolean closed = false;

                @Override
                public ByteBuffer[] getBuffers() {
                    return sub;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                    parent.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            if (this.openCount.decrementAndGet() == 0) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                BaseBufferReadbackStrategy.this.free(this.data[0]);
                this.data[0] = null;
                BaseBufferReadbackStrategy.this.removeChunk(this);
            }
        }
    }

    protected class Marker {
        private final long start;
        private final long mark;
        private final long lhint;

        public Marker(long start, long mark) {
            this.start = start;
            this.mark = mark;
            this.lhint = 0L;
        }

        public Marker(long start, long mark, long lguess) {
            this.start = start;
            this.mark = mark;
            this.lhint = lguess;
        }

        public long getStart() {
            return this.start;
        }

        public long getMark() {
            return this.mark;
        }

        public Chunk getFullChunk() throws IOException {
            FullChunk header = new FullChunk(this.start, 12L);
            int cs = header.getInt();
            if (!SegmentHeaders.CHUNK_START.validate(cs)) {
                throw new AssertionError((Object)"not valid");
            }
            long len = header.getLong();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("buffer overflow");
            }
            header.close();
            return new FullChunk(this.start + 12L, len);
        }

        public VirtualChunk getChunk() throws IOException {
            if (BaseBufferReadbackStrategy.this.closeRequested) {
                throw new IOException("file closed");
            }
            if (this.lhint == 0L) {
                return new VirtualChunk(this.start);
            }
            return new VirtualChunk(this.start + 12L, this.lhint - 12L);
        }
    }
}

