/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.io.StringWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskingBufferSource
implements BufferSource {
    private final BufferSource parent;
    private final Map<BufferEquals, ByteBuffer> out = new ConcurrentHashMap<BufferEquals, ByteBuffer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MaskingBufferSource.class);
    private final ReferenceQueue<ByteBuffer> queue;
    private final boolean DEBUG_LEAKS = Boolean.getBoolean("frs.leak.debug");
    private AtomicLong allocations = new AtomicLong();
    private AtomicLong allocTime = new AtomicLong();
    private AtomicLong lastRecoveryWarnTimeNS = new AtomicLong(0L);

    public MaskingBufferSource(BufferSource parent) {
        this(parent, false);
    }

    public MaskingBufferSource(BufferSource parent, boolean garbageCollector) {
        this.parent = parent;
        this.queue = this.DEBUG_LEAKS || garbageCollector ? new ReferenceQueue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getBuffer(int size) {
        long ntime = System.nanoTime();
        try {
            ByteBuffer src = this.parent.getBuffer(size);
            if (src == null) {
                long lt = this.lastRecoveryWarnTimeNS.get();
                if (ntime - lt > TimeUnit.MINUTES.toNanos(1L) && this.lastRecoveryWarnTimeNS.compareAndSet(lt, ntime)) {
                    LOGGER.info("using heap for recovery, adding more recovery memory could speed recovery " + size);
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                return byteBuffer;
            }
            ByteBuffer byteBuffer = this.add(src);
            return byteBuffer;
        }
        finally {
            long ttime = this.allocTime.addAndGet(System.nanoTime() - ntime);
            long tcount = this.allocations.incrementAndGet();
            if (LOGGER.isDebugEnabled() && tcount % 1000L == 0L) {
                LOGGER.debug("average allocation time:" + ttime / tcount + " for " + tcount + " allocations");
                this.allocTime.set(0L);
                this.allocations.set(0L);
            }
        }
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        ByteBuffer src = this.remove(buffer);
        if (src != null) {
            this.parent.returnBuffer(src);
        } else {
            LOGGER.debug("possible double free of memory resource" + buffer);
        }
    }

    private ByteBuffer remove(ByteBuffer src) {
        ByteBuffer be = this.out.remove(new BufferEquals(src));
        if (be != null) {
            return be;
        }
        return null;
    }

    private ByteBuffer add(ByteBuffer src) {
        BufferEquals key;
        this.clean();
        ByteBuffer pass = src.slice();
        BufferEquals bufferEquals = key = this.queue == null ? new BufferEquals(pass) : new BufferEquals(new BufferHolder(pass, this.queue));
        if (this.out.put(key, src) != null) {
            throw new AssertionError();
        }
        return pass;
    }

    private void clean() {
        if (this.queue == null) {
            return;
        }
        BufferHolder poll = (BufferHolder)this.queue.poll();
        while (poll != null) {
            ByteBuffer leak = this.out.remove(new BufferEquals(poll));
            if (leak != null) {
                LOGGER.debug("LEAK " + poll);
                this.parent.returnBuffer(leak);
            }
            poll = (BufferHolder)this.queue.poll();
        }
    }

    @Override
    public void reclaim() {
        for (Map.Entry<BufferEquals, ByteBuffer> b : new ArrayList<Map.Entry<BufferEquals, ByteBuffer>>(this.out.entrySet())) {
            this.parent.returnBuffer(b.getValue());
        }
        this.out.clear();
        this.parent.reclaim();
    }

    public String toString() {
        return "MaskingBufferSource{parent=" + this.parent + ", out=" + this.out.size() + '}';
    }

    private class BufferEquals {
        private final Object base;
        private final int hashcode;

        public BufferEquals(ByteBuffer src) {
            this.base = src;
            this.hashcode = System.identityHashCode(src);
        }

        public BufferEquals(BufferHolder src) {
            this.base = src;
            this.hashcode = src.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public ByteBuffer getBuffer() {
            if (this.base instanceof BufferHolder) {
                return (ByteBuffer)((BufferHolder)this.base).get();
            }
            return (ByteBuffer)this.base;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof BufferEquals) {
                if (this.base instanceof BufferHolder && this.base.equals(((BufferEquals)obj).base)) {
                    return true;
                }
                return this.getBuffer() == ((BufferEquals)obj).getBuffer();
            }
            return false;
        }
    }

    private static class BufferHolder
    extends WeakReference<ByteBuffer> {
        private final StackTraceElement[] stack;
        private final int hashcode;

        public BufferHolder(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> queue) {
            super(referent, queue);
            this.hashcode = System.identityHashCode(referent);
            this.stack = Thread.currentThread().getStackTrace();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public String toString() {
            StringWriter w = new StringWriter();
            for (StackTraceElement v : this.stack) {
                w.append(v.toString());
                w.append('\n');
            }
            return w.toString();
        }
    }
}

