/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.CachingBufferSource;
import com.terracottatech.frs.io.LimitedCachingBufferSource;
import com.terracottatech.frs.io.SLABBufferSource;
import com.terracottatech.frs.io.SplittingBufferSource;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiLoBufferSource
implements BufferSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiLoBufferSource.class);
    private final int threshold;
    private final AtomicInteger allocations = new AtomicInteger();
    private final SplittingBufferSource lo;
    private final SLABBufferSource hi;
    private final CachingBufferSource hiCache;
    public static final int DEFAULTSLAB = 0x800000;

    public HiLoBufferSource(int totalsize) {
        this(0x800000, totalsize);
    }

    public HiLoBufferSource(int slabsize, int totalsize) {
        this(slabsize / 32, slabsize, totalsize);
    }

    public HiLoBufferSource(int threshold, int slabsize, int totalsize) {
        if (slabsize > totalsize / 4) {
            slabsize = totalsize / 4;
            LOGGER.warn("slab size for memory is greater than 25% of total size.  Adjusting slabsize to 25% of total size or " + slabsize + " bytes");
        }
        if (threshold >= slabsize / 4) {
            threshold = slabsize / 4;
            LOGGER.warn("threshold size for memory is greater than 25% of slab size.  Adjusting threshold to 25% of slabsize or " + threshold + " bytes");
        }
        this.threshold = threshold;
        int maxslabs = totalsize / slabsize - 1;
        this.lo = new SplittingBufferSource(32, slabsize);
        this.hi = new SLABBufferSource(slabsize, maxslabs / 2);
        this.hiCache = new LimitedCachingBufferSource(maxslabs / 2 * slabsize - slabsize);
    }

    HiLoBufferSource(int threshold, BufferProvider provider) {
        this.hiCache = provider.getLargeCache();
        this.hi = provider.getLargeSource();
        this.lo = provider.getSmallSource();
        this.threshold = threshold;
    }

    @Override
    public ByteBuffer getBuffer(int size) {
        if (this.allocations.incrementAndGet() % 8196 == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("allocations=" + this.allocations.get() + " usage=" + this.usage());
        }
        ByteBuffer buffer = null;
        if (size < this.threshold) {
            buffer = this.lo.getBuffer(size);
        }
        if (buffer == null) {
            if (size + 4 >= this.hi.getSlabSize()) {
                buffer = this.hiCache.getBuffer(size + 4);
                if (buffer == null) {
                    buffer = this.largeAllocation(size + 4);
                }
                if (buffer != null) {
                    buffer.putInt(Integer.MIN_VALUE);
                }
            } else {
                buffer = this.hi.getBuffer(size);
                if (buffer != null) {
                    buffer.putInt(0, buffer.getInt(0) | Integer.MIN_VALUE);
                }
            }
        }
        return buffer;
    }

    private synchronized ByteBuffer largeAllocation(int size) {
        if (size < 0) {
            return null;
        }
        try {
            return ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError oome) {
            return null;
        }
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        if (buffer.getInt(0) < 0) {
            if (buffer.capacity() > this.hi.getSlabSize()) {
                if (buffer.getInt(0) != Integer.MIN_VALUE) {
                    throw new AssertionError();
                }
                this.hiCache.returnBuffer(buffer);
            } else {
                buffer.putInt(0, buffer.getInt(0) & Integer.MAX_VALUE);
                this.hi.returnBuffer(buffer);
            }
        } else {
            this.lo.returnBuffer(buffer);
        }
    }

    @Override
    public void reclaim() {
        this.hi.reclaim();
        this.lo.reclaim();
        this.hiCache.reclaim();
    }

    public long usage() {
        return (long)(this.lo.usage() + this.hi.getSize()) + this.hiCache.getSize();
    }

    public String toString() {
        return "HiLoBufferSource{used=" + this.usage() + ", threshold=" + this.threshold + ", \nlo=" + this.lo + ", \nhi=" + this.hi + ", \nhiCache=" + this.hiCache + '}';
    }

    static interface BufferProvider {
        public SplittingBufferSource getSmallSource();

        public SLABBufferSource getLargeSource();

        public CachingBufferSource getLargeCache();
    }
}

