/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import java.io.IOException;

public class SizeBasedCompactionPolicy
implements CompactionPolicy {
    private final IOManager ioManager;
    private final ObjectManager<?, ?, ?> objectManager;
    private final double sizeThreshold;
    private final double compactionPercentage;
    private boolean isCompacting;
    private long entriesToCompact;

    public SizeBasedCompactionPolicy(IOManager ioManager, ObjectManager<?, ?, ?> objectManager, Configuration configuration) {
        this.ioManager = ioManager;
        this.objectManager = objectManager;
        this.sizeThreshold = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_THRESHOLD);
        this.compactionPercentage = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_AMOUNT);
    }

    @Override
    public boolean startCompacting() {
        if (this.isCompacting) {
            throw new IllegalStateException("Already compacting");
        }
        return this.internalStartCompacting();
    }

    private boolean internalStartCompacting() {
        if ((double)this.getRatio(this.objectManager, this.ioManager) <= this.sizeThreshold) {
            this.isCompacting = true;
            this.entriesToCompact = this.calculateEntriesToCompact();
            return true;
        }
        return false;
    }

    private long calculateEntriesToCompact() {
        return (long)((double)this.objectManager.size() * this.compactionPercentage);
    }

    protected float getRatio(ObjectManager<?, ?, ?> objectManager, IOManager ioManager) {
        try {
            long sizeInBytes = objectManager.sizeInBytes();
            long size = objectManager.size();
            long liveSize = ioManager.getStatistics().getLiveSize();
            long minimumOverhead = LogRegionPacker.getMinimumRecordOverhead() * size;
            long optimallyCompactedSize = sizeInBytes + minimumOverhead;
            return (float)((double)optimallyCompactedSize / (double)liveSize);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get log size.", e);
        }
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        if (!this.isCompacting) {
            throw new IllegalStateException("Compaction is not started.");
        }
        return --this.entriesToCompact > 0L || this.internalStartCompacting();
    }

    @Override
    public void stoppedCompacting() {
        if (!this.isCompacting) {
            throw new IllegalStateException("Compaction is not started.");
        }
        this.isCompacting = false;
    }
}

