/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.action.NullAction;
import com.terracottatech.frs.compaction.CompactionAction;
import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.compaction.LSNGapCompactionPolicy;
import com.terracottatech.frs.compaction.LegacySizeBasedCompactionPolicy;
import com.terracottatech.frs.compaction.NoCompactionPolicy;
import com.terracottatech.frs.compaction.SizeBasedCompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.transaction.TransactionManager;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorImpl
implements Compactor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Compactor.class);
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private final TransactionManager transactionManager;
    private final ActionManager actionManager;
    private final LogManager logManager;
    private final boolean useLimiting = !Boolean.getBoolean("frs.compactor.limiter.disable");
    private final Semaphore compactionCondition = new Semaphore(0);
    private volatile boolean alive = false;
    private final CompactionPolicy policy;
    private final long runIntervalSeconds;
    private final long retryIntervalSeconds;
    private final long compactActionThrottle;
    private final int startThreshold;
    private CompactorThread compactorThread;
    private volatile boolean signalPause;
    private boolean paused;

    CompactorImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, ActionManager actionManager, LogManager logManager, CompactionPolicy policy, long runIntervalSeconds, long retryIntervalSeconds, long compactActionThrottle, int startThreshold) {
        this.objectManager = objectManager;
        this.transactionManager = transactionManager;
        this.actionManager = actionManager;
        this.logManager = logManager;
        this.policy = policy;
        this.runIntervalSeconds = runIntervalSeconds;
        this.retryIntervalSeconds = retryIntervalSeconds;
        this.compactActionThrottle = compactActionThrottle;
        this.startThreshold = startThreshold;
    }

    public CompactorImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, IOManager ioManager, Configuration configuration, ActionManager actionManager) throws RestartStoreException {
        this(objectManager, transactionManager, actionManager, logManager, CompactorImpl.getPolicy(configuration, objectManager, logManager, ioManager), configuration.getLong(FrsProperty.COMPACTOR_RUN_INTERVAL), configuration.getLong(FrsProperty.COMPACTOR_RETRY_INTERVAL), configuration.getLong(FrsProperty.COMPACTOR_THROTTLE_AMOUNT), configuration.getInt(FrsProperty.COMPACTOR_START_THRESHOLD));
    }

    private static CompactionPolicy getPolicy(Configuration configuration, ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, LogManager logManager, IOManager ioManager) throws RestartStoreException {
        String policy = configuration.getString(FrsProperty.COMPACTOR_POLICY);
        if ("LSNGapCompactionPolicy".equals(policy)) {
            return new LSNGapCompactionPolicy(objectManager, logManager, configuration);
        }
        if ("SizeBasedCompactionPolicy".equals(policy)) {
            return new SizeBasedCompactionPolicy(ioManager, objectManager, configuration);
        }
        if ("LegacySizeBasedCompactionPolicy".equals(policy)) {
            return new LegacySizeBasedCompactionPolicy(ioManager, objectManager, configuration);
        }
        if ("NoCompactionPolicy".equals(policy)) {
            LOGGER.warn("Compactor policy is set to 'NoCompactionPolicy'. No compaction will be done.");
            return new NoCompactionPolicy();
        }
        throw new RestartStoreException("Unknown compaction policy " + policy);
    }

    @Override
    public void startup() {
        if (!this.alive) {
            this.alive = true;
            LOGGER.info("using " + this.policy.getClass().getName() + " compaction policy");
            this.compactorThread = new CompactorThread();
            this.compactorThread.start();
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        if (this.alive) {
            this.alive = false;
            this.compactorThread.interrupt();
            this.compactorThread.join();
        }
    }

    @Override
    public void generatedGarbage(long lsn) {
        try {
            this.compactionCondition.release();
        }
        catch (Error e) {
            LOGGER.warn("error generating garbage", (Throwable)e);
        }
    }

    @Override
    public void compactNow() {
        try {
            this.compactionCondition.drainPermits();
            this.compactionCondition.release(this.startThreshold);
        }
        catch (Error e) {
            LOGGER.warn("error generating garbage", (Throwable)e);
        }
    }

    private synchronized boolean checkForPause() throws InterruptedException {
        boolean wasPaused = false;
        if (this.signalPause) {
            this.signalPause = false;
            this.paused = true;
            this.notifyAll();
            while (this.paused) {
                wasPaused = true;
                this.wait();
            }
        }
        return wasPaused;
    }

    @Override
    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        this.signalPause = true;
        this.compactNow();
        boolean interrupted = false;
        while (!this.paused && this.signalPause) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void unpause() {
        if (!this.paused && !this.signalPause) {
            return;
        }
        this.signalPause = false;
        this.paused = false;
        this.notifyAll();
    }

    private class CompactorThread
    extends Thread {
        CompactorThread() {
            this.setDaemon(true);
            this.setName("CompactorThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (CompactorImpl.this.alive) {
                try {
                    CompactorImpl.this.compactionCondition.tryAcquire(CompactorImpl.this.startThreshold, CompactorImpl.this.runIntervalSeconds, TimeUnit.SECONDS);
                    if (CompactorImpl.this.checkForPause()) continue;
                    NullAction barrier = new NullAction();
                    CompactorImpl.this.actionManager.happened(barrier).get();
                    long lowLsn = CompactorImpl.this.objectManager.getLowestLsn();
                    if (lowLsn == -1L) {
                        lowLsn = barrier.getLsn();
                    }
                    if (CompactorImpl.this.policy.startCompacting() && CompactorImpl.this.alive) {
                        try {
                            this.compact();
                        }
                        finally {
                            CompactorImpl.this.policy.stoppedCompacting();
                        }
                    }
                    CompactorImpl.this.logManager.updateLowestLsn(lowLsn);
                    CompactorImpl.this.actionManager.syncHappened(new NullAction()).get();
                }
                catch (InterruptedException e) {
                    LOGGER.info("Compactor is interrupted. Shutting down.");
                    return;
                }
                catch (Throwable t) {
                    LOGGER.error("Error performing compaction. Temporarily disabling compaction for " + CompactorImpl.this.retryIntervalSeconds + " seconds.", t);
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(CompactorImpl.this.retryIntervalSeconds));
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Compactor is interrupted. Shutting down.");
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compact() throws ExecutionException, InterruptedException {
            CompactorImpl.this.compactionCondition.drainPermits();
            long ceilingLsn = CompactorImpl.this.transactionManager.getLowestOpenTransactionLsn();
            long liveSize = CompactorImpl.this.objectManager.size();
            long compactedCount = 0L;
            long baseLsn = CompactorImpl.this.logManager.lowestLsn();
            long startTime = System.currentTimeMillis();
            long rangeLsn = (CompactorImpl.this.logManager.currentLsn() - baseLsn - liveSize) / 1000L;
            if (rangeLsn == 0L) {
                rangeLsn = 1L;
            }
            if (rangeLsn < 0L) {
                throw new AssertionError((Object)"not all LSNs accounted for");
            }
            long startLsn = 0L;
            long lastLsn = 0L;
            LOGGER.debug("range is " + rangeLsn + " ceiling:" + ceilingLsn + " base:" + baseLsn + " live:" + liveSize);
            while (compactedCount < liveSize && !CompactorImpl.this.signalPause) {
                Future<Void> written;
                ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> compactionEntry = CompactorImpl.this.objectManager.acquireCompactionEntry(CompactorImpl.this.useLimiting ? baseLsn + rangeLsn : ceilingLsn);
                if (compactionEntry == null) {
                    if (!CompactorImpl.this.useLimiting || baseLsn + rangeLsn > Math.min(CompactorImpl.this.logManager.currentLsn(), ceilingLsn)) break;
                    LOGGER.debug("bumping range to " + (rangeLsn <<= 1));
                    continue;
                }
                lastLsn = compactionEntry.getLsn();
                if (startLsn == 0L) {
                    startLsn = lastLsn;
                }
                ++compactedCount;
                try {
                    CompactionAction compactionAction = new CompactionAction(CompactorImpl.this.objectManager, compactionEntry);
                    written = CompactorImpl.this.actionManager.happened(compactionAction);
                    compactionAction.updateObjectManager();
                }
                finally {
                    CompactorImpl.this.objectManager.releaseCompactionEntry(compactionEntry);
                }
                if (!CompactorImpl.this.policy.compacted(compactionEntry)) break;
                if (compactedCount % CompactorImpl.this.compactActionThrottle != 0L) continue;
                written.get();
                written = null;
                CompactorImpl.this.logManager.updateLowestLsn(CompactorImpl.this.objectManager.getLowestLsn());
            }
            LOGGER.debug("compaction base lsn:" + baseLsn + " start lsn:" + baseLsn + " end lsn:" + lastLsn + " live size:" + liveSize);
            LOGGER.debug("compacted " + compactedCount + " entries in " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime) + " secs.");
        }
    }
}

