/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.config.BindPort;
import org.terracotta.config.Config;
import org.terracotta.config.Server;
import org.terracotta.config.Servers;
import org.terracotta.config.Service;
import org.terracotta.config.TCConfigurationParser;
import org.terracotta.config.TCConfigurationSetupException;
import org.terracotta.config.TcConfig;
import org.terracotta.config.TcConfiguration;
import org.terracotta.config.service.ExtendedConfigParser;
import org.terracotta.config.service.ServiceConfigParser;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NonSubstitutingTCConfigurationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonSubstitutingTCConfigurationParser.class);
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final URL TERRACOTTA_XML_SCHEMA = TCConfigurationParser.class.getResource("/terracotta.xsd");
    private static final String WILDCARD_IP = "0.0.0.0";
    private static final int MIN_PORTNUMBER = 4095;
    private static final int MAX_PORTNUMBER = 65535;
    private static final String DEFAULT_LOGS = "logs";

    private static TcConfiguration parseStream(InputStream in, String source, ClassLoader loader) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        HashMap<URI, ServiceConfigParser> serviceParsers = new HashMap<URI, ServiceConfigParser>();
        HashMap<URI, ExtendedConfigParser> configParsers = new HashMap<URI, ExtendedConfigParser>();
        schemaSources.add(new StreamSource(TERRACOTTA_XML_SCHEMA.openStream()));
        for (ServiceConfigParser serviceConfigParser : NonSubstitutingTCConfigurationParser.loadServiceConfigurationParserClasses(loader)) {
            schemaSources.add(serviceConfigParser.getXmlSchema());
            serviceParsers.put(serviceConfigParser.getNamespace(), serviceConfigParser);
        }
        for (ExtendedConfigParser extendedConfigParser : NonSubstitutingTCConfigurationParser.loadConfigurationParserClasses(loader)) {
            schemaSources.add(extendedConfigParser.getXmlSchema());
            configParsers.put(extendedConfigParser.getNamespace(), extendedConfigParser);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[0])));
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        CollectingErrorHandler errorHandler = new CollectingErrorHandler();
        documentBuilder.setErrorHandler(errorHandler);
        Element config = documentBuilder.parse(in).getDocumentElement();
        Collection<SAXParseException> parseErrors = errorHandler.getErrors();
        if (parseErrors.size() != 0) {
            StringBuilder buf = new StringBuilder("Couldn't parse configuration file, there are " + parseErrors.size() + " error(s)." + System.lineSeparator());
            int i = 1;
            for (SAXParseException parseError : parseErrors) {
                buf.append(" [").append(i).append("] Line ").append(parseError.getLineNumber()).append(", column ").append(parseError.getColumnNumber()).append(": ").append(parseError.getMessage()).append(System.lineSeparator());
                ++i;
            }
            throw new TCConfigurationSetupException(buf.toString());
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.terracotta.config", (ClassLoader)TCConfigurationParser.class.getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            TcConfig tcConfig = (TcConfig)u.unmarshal((Node)config, TcConfig.class).getValue();
            if (tcConfig.getServers() == null) {
                Servers servers = new Servers();
                tcConfig.setServers(servers);
            }
            if (tcConfig.getServers().getServer().isEmpty()) {
                tcConfig.getServers().getServer().add(new Server());
            }
            NonSubstitutingTCConfigurationParser.applyPlatformDefaults(tcConfig);
            ArrayList<ServiceProviderConfiguration> serviceConfigurations = new ArrayList<ServiceProviderConfiguration>();
            ArrayList<Object> configObjects = new ArrayList<Object>();
            if (tcConfig.getPlugins() != null && tcConfig.getPlugins().getConfigOrService() != null) {
                for (Object plugin : tcConfig.getPlugins().getConfigOrService()) {
                    ServiceConfigParser parser;
                    URI namespace;
                    Element element;
                    if (plugin instanceof Service) {
                        element = ((Service)plugin).getServiceContent();
                        namespace = URI.create(element.getNamespaceURI());
                        parser = (ServiceConfigParser)serviceParsers.get(namespace);
                        if (parser == null) {
                            throw new TCConfigurationSetupException("Can't find parser for service " + namespace);
                        }
                        ServiceProviderConfiguration serviceProviderConfiguration = parser.parse(element, source);
                        serviceConfigurations.add(serviceProviderConfiguration);
                        continue;
                    }
                    if (!(plugin instanceof Config)) continue;
                    element = ((Config)plugin).getConfigContent();
                    namespace = URI.create(element.getNamespaceURI());
                    parser = (ExtendedConfigParser)configParsers.get(namespace);
                    if (parser == null) {
                        throw new TCConfigurationSetupException("Can't find parser for config " + namespace);
                    }
                    Object co = parser.parse(element, source);
                    configObjects.add(co);
                }
            }
            return new TcConfiguration(tcConfig, source, configObjects, serviceConfigurations);
        }
        catch (JAXBException e) {
            throw new TCConfigurationSetupException((Exception)((Object)e));
        }
    }

    public static Element getRootElement(InputStream in, ClassLoader loader) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        schemaSources.add(new StreamSource(TERRACOTTA_XML_SCHEMA.openStream()));
        for (ServiceConfigParser serviceConfigParser : NonSubstitutingTCConfigurationParser.loadServiceConfigurationParserClasses(loader)) {
            schemaSources.add(serviceConfigParser.getXmlSchema());
        }
        for (ExtendedConfigParser extendedConfigParser : NonSubstitutingTCConfigurationParser.loadConfigurationParserClasses(loader)) {
            schemaSources.add(extendedConfigParser.getXmlSchema());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[0])));
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        CollectingErrorHandler errorHandler = new CollectingErrorHandler();
        documentBuilder.setErrorHandler(errorHandler);
        Element config = documentBuilder.parse(in).getDocumentElement();
        Collection<SAXParseException> parseErrors = errorHandler.getErrors();
        if (parseErrors.size() != 0) {
            StringBuilder buf = new StringBuilder("Couldn't parse configuration file, there are " + parseErrors.size() + " error(s)." + System.lineSeparator());
            int i = 1;
            for (SAXParseException parseError : parseErrors) {
                buf.append(" [").append(i).append("] Line ").append(parseError.getLineNumber()).append(", column ").append(parseError.getColumnNumber()).append(": ").append(parseError.getMessage()).append(System.lineSeparator());
                ++i;
            }
            throw new TCConfigurationSetupException(buf.toString());
        }
        return config;
    }

    public static void applyPlatformDefaults(TcConfig tcConfig) {
        for (Server server : tcConfig.getServers().getServer()) {
            NonSubstitutingTCConfigurationParser.setDefaultBind(server);
            NonSubstitutingTCConfigurationParser.initializeTsaPort(server);
            NonSubstitutingTCConfigurationParser.initializeTsaGroupPort(server);
            NonSubstitutingTCConfigurationParser.initializeNameAndHost(server);
            NonSubstitutingTCConfigurationParser.initializeLogsDirectory(server);
        }
    }

    private static void initializeTsaPort(Server server) {
        if (server.getTsaPort() == null) {
            BindPort tsaPort = new BindPort();
            tsaPort.setValue(9410);
            server.setTsaPort(tsaPort);
        }
        if (server.getTsaPort().getBind() == null) {
            server.getTsaPort().setBind(server.getBind());
        }
    }

    private static void initializeLogsDirectory(Server server) {
        if (server.getLogs() == null) {
            server.setLogs("logs/%h-" + server.getTsaPort().getValue());
        }
    }

    private static void initializeTsaGroupPort(Server server) {
        if (server.getTsaGroupPort() == null) {
            BindPort l2GrpPort = new BindPort();
            server.setTsaGroupPort(l2GrpPort);
            int tempGroupPort = server.getTsaPort().getValue() + 20;
            int defaultGroupPort = tempGroupPort <= 65535 ? tempGroupPort : tempGroupPort % 65535 + 4095;
            l2GrpPort.setValue(defaultGroupPort);
            l2GrpPort.setBind(server.getBind());
        } else if (server.getTsaGroupPort().getBind() == null) {
            server.getTsaGroupPort().setBind(server.getBind());
        }
    }

    private static void initializeNameAndHost(Server server) {
        if (server.getHost() == null || server.getHost().trim().length() == 0) {
            if (server.getName() == null) {
                throw new IllegalStateException("Conversion process requires at least a server name or host name to be defined");
            }
            server.setHost(server.getName());
        }
        if (server.getName() == null || server.getName().trim().length() == 0) {
            int tsaPort = server.getTsaPort().getValue();
            server.setName(server.getHost() + (tsaPort > 0 ? "-" + tsaPort : ""));
        }
    }

    private static void setDefaultBind(Server s) {
        if (s.getBind() == null || s.getBind().trim().length() == 0) {
            s.setBind(WILDCARD_IP);
        }
        s.setBind(s.getBind());
    }

    private static TcConfiguration convert(InputStream in, String path, ClassLoader loader) throws IOException, SAXException {
        byte[] data = new byte[in.available()];
        in.read(data);
        in.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return NonSubstitutingTCConfigurationParser.parseStream(bais, path, loader);
    }

    public static TcConfiguration parse(File file, ClassLoader loader) throws IOException, SAXException {
        try (FileInputStream in = new FileInputStream(file);){
            TcConfiguration tcConfiguration = NonSubstitutingTCConfigurationParser.convert(in, file.getParent(), loader);
            return tcConfiguration;
        }
    }

    public static TcConfiguration parse(String xmlText, ClassLoader loader) throws IOException, SAXException {
        return NonSubstitutingTCConfigurationParser.convert(new ByteArrayInputStream(xmlText.getBytes(StandardCharsets.UTF_8)), null, loader);
    }

    public static TcConfiguration parse(InputStream stream, ClassLoader loader) throws IOException, SAXException {
        return NonSubstitutingTCConfigurationParser.convert(stream, null, loader);
    }

    public static TcConfiguration parse(URL url, ClassLoader loader) throws IOException, SAXException {
        return NonSubstitutingTCConfigurationParser.convert(url.openStream(), url.getPath(), loader);
    }

    public static TcConfiguration parse(InputStream in, String source, ClassLoader loader) throws IOException, SAXException {
        return NonSubstitutingTCConfigurationParser.parseStream(in, source, loader);
    }

    private static ServiceLoader<ServiceConfigParser> loadServiceConfigurationParserClasses(ClassLoader loader) {
        return ServiceLoader.load(ServiceConfigParser.class, loader);
    }

    private static ServiceLoader<ExtendedConfigParser> loadConfigurationParserClasses(ClassLoader loader) {
        return ServiceLoader.load(ExtendedConfigParser.class, loader);
    }

    private static class CollectingErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> errors = new ArrayList<SAXParseException>();

        private CollectingErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            LOGGER.warn(exception.getLocalizedMessage());
        }

        public Collection<SAXParseException> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }
    }
}

