/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.MemoryUnit;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.config.Config;
import org.terracotta.config.Service;
import org.terracotta.config.TcConfig;
import org.terracotta.config.data_roots.DataRootConfigParser;
import org.terracotta.config.service.ExtendedConfigParser;
import org.terracotta.config.service.ServiceConfigParser;
import org.terracotta.data.config.DataDirectories;
import org.terracotta.data.config.DataRootMapping;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.RawPath;
import org.terracotta.lease.service.config.LeaseConfigurationParser;
import org.terracotta.lease.service.config.LeaseElement;
import org.terracotta.offheapresource.OffHeapResourceConfigurationParser;
import org.terracotta.offheapresource.config.OffheapResourcesType;
import org.terracotta.offheapresource.config.ResourceType;
import org.w3c.dom.Element;

public class CommonMapper {
    private static final String WILDCARD_IP = "0.0.0.0";
    private Map<String, ExtendedConfigParser> configParsers = new HashMap<String, ExtendedConfigParser>();
    private Map<String, ServiceConfigParser> serviceConfigParsers = new HashMap<String, ServiceConfigParser>();

    public CommonMapper(ClassLoader classLoader) {
        for (ExtendedConfigParser extendedConfigParser : ServiceLoader.load(ExtendedConfigParser.class, classLoader)) {
            this.configParsers.put(extendedConfigParser.getNamespace().toString(), extendedConfigParser);
        }
        for (ServiceConfigParser serviceConfigParser : ServiceLoader.load(ServiceConfigParser.class, classLoader)) {
            this.serviceConfigParsers.put(serviceConfigParser.getNamespace().toString(), serviceConfigParser);
        }
    }

    public String moreRestrictive(String specific, String general) {
        if (WILDCARD_IP.equals(specific) && !WILDCARD_IP.equals(general)) {
            return general;
        }
        return specific;
    }

    public Optional<Map<String, String>> toProperties(TcConfig xmlTcConfig) {
        return Optional.ofNullable(xmlTcConfig.getTcProperties()).map(tcProperties -> {
            HashMap properties = new HashMap();
            tcProperties.getProperty().forEach(p -> properties.put(p.getName(), p.getValue()));
            return properties;
        });
    }

    public Optional<Measure<TimeUnit>> toClientLeaseDuration(Map<Class<?>, List<Object>> plugins) {
        return Optional.ofNullable(plugins.get(LeaseElement.class)).flatMap(list -> list.stream().map(LeaseElement.class::cast).map(leaseElement -> Measure.of((long)Long.parseLong(leaseElement.getLeaseValue()), (Enum)TimeUnit.valueOf((String)leaseElement.getTimeUnit().toUpperCase()))).findAny());
    }

    public Optional<Map<String, RawPath>> toDataDirs(Map<Class<?>, List<Object>> plugins, Predicate<DataRootMapping> filter) {
        return Optional.ofNullable(plugins.get(DataRootMapping.class)).map(list -> list.stream().map(DataRootMapping.class::cast).filter(filter).collect(Collectors.toMap(DataRootMapping::getName, mapping -> RawPath.valueOf((String)mapping.getValue()))));
    }

    public Optional<Map<String, Measure<MemoryUnit>>> toOffheapResources(Map<Class<?>, List<Object>> plugins) {
        return Optional.ofNullable(plugins.get(ResourceType.class)).map(list -> list.stream().map(ResourceType.class::cast).collect(Collectors.toMap(ResourceType::getName, r -> Measure.of((long)r.getValue().longValue(), (Enum)MemoryUnit.parse((String)r.getUnit().value())))));
    }

    public FailoverPriority toFailoverPriority(org.terracotta.config.FailoverPriority failoverPriority) {
        return failoverPriority == null ? FailoverPriority.availability() : (failoverPriority.getConsistency() != null ? (failoverPriority.getConsistency().getVoter() == null ? FailoverPriority.consistency() : FailoverPriority.consistency((int)failoverPriority.getConsistency().getVoter().getCount())) : FailoverPriority.availability());
    }

    public Map<Class<?>, List<Object>> parsePlugins(String xml, TcConfig tcConfig) {
        return this.parsePlugins(xml, tcConfig, (p, e) -> Optional.empty(), (p, e) -> Optional.empty());
    }

    public Map<Class<?>, List<Object>> parsePlugins(String xml, TcConfig tcConfig, BiFunction<ExtendedConfigParser, Element, Optional<Stream<?>>> configMapper, BiFunction<ServiceConfigParser, Element, Optional<Stream<?>>> serviceMapper) {
        if (tcConfig.getPlugins() != null) {
            return tcConfig.getPlugins().getConfigOrService().stream().flatMap(o -> this.parsePlugin(xml, o, configMapper, serviceMapper)).collect(Collectors.groupingBy(Object::getClass));
        }
        return Collections.emptyMap();
    }

    protected Stream<?> parsePlugin(String xml, Object o, BiFunction<ExtendedConfigParser, Element, Optional<Stream<?>>> configMapper, BiFunction<ServiceConfigParser, Element, Optional<Stream<?>>> serviceMapper) {
        if (o instanceof Config) {
            Element element = ((Config)o).getConfigContent();
            ExtendedConfigParser parser = this.configParsers.get(element.getNamespaceURI());
            if (parser == null) {
                throw new AssertionError((Object)("ExtendedConfigParser not found for namespace " + element.getNamespaceURI()));
            }
            if (parser instanceof DataRootConfigParser) {
                return ((DataDirectories)((DataRootConfigParser)parser).parser().apply(element)).getDirectory().stream();
            }
            if (parser instanceof OffHeapResourceConfigurationParser) {
                return ((OffheapResourcesType)((OffHeapResourceConfigurationParser)parser).parser().apply(element)).getResource().stream();
            }
            return configMapper.apply(parser, element).orElseGet(() -> Stream.of(parser.parse(element, xml)));
        }
        if (o instanceof Service) {
            Element element = ((Service)o).getServiceContent();
            ServiceConfigParser parser = this.serviceConfigParsers.get(element.getNamespaceURI());
            if (parser == null) {
                throw new AssertionError((Object)("ServiceConfigParser not found for namespace " + element.getNamespaceURI()));
            }
            if (parser instanceof LeaseConfigurationParser) {
                return Stream.of(((LeaseConfigurationParser)parser).parser().apply(element));
            }
            return serviceMapper.apply(parser, element).orElseGet(() -> Stream.of(parser.parse(element, xml)));
        }
        throw new AssertionError((Object)("Unsupported type: " + o.getClass()));
    }

    public Optional<Measure<TimeUnit>> toClientReconnectWindow(TcConfig tcConfig) {
        return tcConfig == null || tcConfig.getServers() == null || tcConfig.getServers().getClientReconnectWindow() == null ? Optional.empty() : Optional.of(Measure.of((long)tcConfig.getServers().getClientReconnectWindow().intValue(), (Enum)TimeUnit.SECONDS));
    }
}

