/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.validators;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.config.service.ConfigValidator;
import org.terracotta.config.service.ValidationException;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.ErrorCodeMapper;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.exception.InvalidInputConfigurationContentException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidationWrapper {
    private final ConfigValidator validator;

    public ValidationWrapper(ConfigValidator configValidator) {
        this.validator = configValidator;
    }

    public void check(Map<Path, Node> fileNodeMap) {
        AtomicReference previousNodes = new AtomicReference();
        AtomicReference previousPathRef = new AtomicReference();
        fileNodeMap.forEach((path, node) -> {
            this.validate(this.validator, (Element)node, (Path)path);
            if (previousNodes.get() != null) {
                this.compare(this.validator, (Element)node, (Element)previousNodes.get(), (Path)path, (Path)previousPathRef.get());
            }
            previousNodes.set(node);
            previousPathRef.set(path);
        });
    }

    public void validate(ConfigValidator validator, Element element, Path path) {
        try {
            if (validator != null) {
                validator.validate(element);
            }
        }
        catch (ValidationException e) {
            ErrorCodeMapper.ErrorDetail errorDetail = ErrorCodeMapper.getErrorCode(e.getErrorId());
            throw new InvalidInputConfigurationContentException(errorDetail.getErrorCode(), String.format(errorDetail.getErrorMessage(), path.toString()), new Tuple2[0]);
        }
    }

    private void compare(ConfigValidator validator, Element elementOne, Element elementOther, Path pathOne, Path pathOther) {
        try {
            if (validator != null) {
                validator.validateAgainst(elementOne, elementOther);
            }
        }
        catch (ValidationException e) {
            ErrorCodeMapper.ErrorDetail errorDetail = ErrorCodeMapper.getErrorCode(e.getErrorId());
            throw new InvalidInputConfigurationContentException(errorDetail.getErrorCode(), String.format(errorDetail.getErrorMessage(), pathOne.toString(), pathOther.toString()), new Tuple2[0]);
        }
    }
}

