/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter;

import com.fasterxml.jackson.databind.Module;
import java.nio.file.Path;
import java.time.Clock;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.json.DynamicConfigApiJsonModule;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.ClusterActivationNomadChange;
import org.terracotta.dynamic_config.api.service.IParameterSubstitutor;
import org.terracotta.dynamic_config.server.api.DynamicConfigNomadServer;
import org.terracotta.dynamic_config.server.configuration.nomad.NomadServerFactory;
import org.terracotta.dynamic_config.server.configuration.nomad.persistence.ConfigStorageException;
import org.terracotta.dynamic_config.server.configuration.nomad.persistence.NomadConfigurationManager;
import org.terracotta.json.ObjectMapperFactory;
import org.terracotta.nomad.NomadEnvironment;
import org.terracotta.nomad.client.NomadClient;
import org.terracotta.nomad.client.NomadEndpoint;
import org.terracotta.nomad.client.change.ChangeResultReceiver;
import org.terracotta.nomad.client.change.NomadChange;
import org.terracotta.nomad.client.results.NomadFailureReceiver;
import org.terracotta.nomad.server.ChangeApplicator;
import org.terracotta.nomad.server.NomadException;
import org.terracotta.nomad.server.NomadServer;
import org.terracotta.nomad.server.PotentialApplicationResult;
import org.terracotta.persistence.sanskrit.SanskritException;

public class ConfigRepoProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRepoProcessor.class);
    private final Path outputFolderPath;
    private final NomadServerFactory nomadServerFactory = new NomadServerFactory(new ObjectMapperFactory().withModule((Module)new DynamicConfigApiJsonModule()));

    public ConfigRepoProcessor(Path outputFolderPath) {
        this.outputFolderPath = outputFolderPath;
    }

    public void process(Cluster cluster) {
        this.saveToNomad(cluster);
    }

    private void saveToNomad(Cluster cluster) {
        List endpoints = cluster.getNodes().stream().map(node -> new NomadEndpoint(node.getInternalHostPort(), this.getNomadServer(cluster, (Node)node))).collect(Collectors.toList());
        NomadEnvironment environment = new NomadEnvironment();
        try (NomadClient nomadClient = new NomadClient(endpoints, environment.getHost(), environment.getUser(), Clock.systemUTC());){
            NomadFailureReceiver failureRecorder = new NomadFailureReceiver();
            nomadClient.tryApplyChange((ChangeResultReceiver)failureRecorder, (NomadChange)new ClusterActivationNomadChange(cluster));
            failureRecorder.reThrowErrors();
        }
    }

    protected NomadServer<NodeContext> getNomadServer(Cluster cluster, Node node) {
        int stripeId = cluster.getStripeIdByNode(node.getUID()).getAsInt();
        Stripe stripe = (Stripe)cluster.getStripeByNode(node.getUID()).get();
        Path configPath = this.outputFolderPath.resolve("stripe-" + stripeId).resolve(node.getName());
        LOGGER.trace("Preparing configuration folder for node: " + node.getName() + " in stripe: " + stripe.getName() + " at: " + configPath.toAbsolutePath());
        return this.createServer(configPath, node);
    }

    private NomadServer<NodeContext> createServer(Path configPath, final Node node) {
        NomadConfigurationManager nomadConfigurationManager = new NomadConfigurationManager(configPath, IParameterSubstitutor.identity());
        nomadConfigurationManager.createDirectories();
        ChangeApplicator<NodeContext> changeApplicator = new ChangeApplicator<NodeContext>(){

            public PotentialApplicationResult<NodeContext> tryApply(NodeContext existing, NomadChange change) {
                return PotentialApplicationResult.allow((Object)new NodeContext(((ClusterActivationNomadChange)change).getCluster(), node.getUID()));
            }

            public void apply(NomadChange change) {
            }
        };
        try {
            DynamicConfigNomadServer nomadServer = this.nomadServerFactory.createServer(nomadConfigurationManager, node.getName(), null);
            nomadServer.setChangeApplicator((ChangeApplicator)changeApplicator);
            return nomadServer;
        }
        catch (ConfigStorageException | NomadException | SanskritException e) {
            throw new RuntimeException(e);
        }
    }
}

