/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.upgrade_tools.config_converter;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.RawPath;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.TcConfigMapper;
import org.terracotta.dynamic_config.cli.upgrade_tools.config_converter.xml.TcConfigMapperDiscovery;

public class ConfigConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigConverter.class);
    private final Consumer<Cluster> postConversionProcessor;
    private final boolean acceptRelativePaths;

    public ConfigConverter(Consumer<Cluster> conversionProcessor) {
        this(conversionProcessor, false);
    }

    public ConfigConverter(Consumer<Cluster> postConversionProcessor, boolean acceptRelativePaths) {
        this.postConversionProcessor = Objects.requireNonNull(postConversionProcessor);
        this.acceptRelativePaths = acceptRelativePaths;
    }

    public void processInput(String clusterName, List<String> stripeNames, Path ... tcConfigPaths) {
        TcConfigMapper mapper = new TcConfigMapperDiscovery(this.getClass().getClassLoader()).find().orElseThrow(() -> new AssertionError((Object)("No " + TcConfigMapper.class.getName() + " service implementation found on classpath")));
        Cluster cluster = mapper.parseConfig(clusterName, stripeNames, tcConfigPaths);
        this.validateAgainstRelativePath(cluster);
        new ClusterValidator(cluster).validate(ClusterState.ACTIVATED);
        this.postConversionProcessor.accept(cluster);
    }

    protected void validateAgainstRelativePath(Cluster cluster) {
        HashMap<String, String> perNodeWarnings = new HashMap<String, String>();
        if (!this.acceptRelativePaths) {
            for (Stripe stripe : cluster.getStripes()) {
                for (Node node : stripe.getNodes()) {
                    List<String> placeHolderList = this.checkPlaceHolders(node);
                    if (!placeHolderList.isEmpty()) {
                        perNodeWarnings.put(node.getName(), placeHolderList.toString());
                        continue;
                    }
                    String settingName = this.containsRelativePaths(node);
                    if (settingName == null) continue;
                    throw new RuntimeException("The config: " + settingName + " for server: " + node.getName() + " in stripe: " + stripe.toShapeString() + " contains relative paths, which will not work as intended after config conversion. Use absolute paths instead.");
                }
            }
        }
        if (!perNodeWarnings.isEmpty()) {
            LOGGER.warn("{}NOTE: The following nodes were found to have placeholders in paths, which may not work as intended on new hosts after config conversion: {}{}{}", new Object[]{System.lineSeparator(), System.lineSeparator(), perNodeWarnings.entrySet().stream().map(e -> " - Node: " + (String)e.getKey() + ". Configs containing placeholders: " + (String)e.getValue()).collect(Collectors.joining(System.lineSeparator())), System.lineSeparator()});
        }
    }

    private List<String> checkPlaceHolders(Node node) {
        ArrayList<String> placeHolders = new ArrayList<String>();
        ((Map)node.getDataDirs().orDefault()).values().stream().map(RawPath::toString).filter(Substitutor::containsSubstitutionParams).findAny().ifPresent(path -> placeHolders.add("data-dirs"));
        node.getBackupDir().filter(path -> Substitutor.containsSubstitutionParams((String)path.toString())).ifPresent(path -> placeHolders.add("backup-dir"));
        node.getLogDir().filter(path -> Substitutor.containsSubstitutionParams((String)path.toString())).ifPresent(path -> placeHolders.add("log-dir"));
        node.getMetadataDir().filter(path -> Substitutor.containsSubstitutionParams((String)path.toString())).ifPresent(path -> placeHolders.add("metadata-dir"));
        node.getSecurityDir().filter(path -> Substitutor.containsSubstitutionParams((String)path.toString())).ifPresent(path -> placeHolders.add("security-dir"));
        node.getSecurityAuditLogDir().filter(path -> Substitutor.containsSubstitutionParams((String)path.toString())).ifPresent(path -> placeHolders.add("audit-log-dir"));
        return placeHolders;
    }

    private String containsRelativePaths(Node node) {
        if (((Map)node.getDataDirs().orDefault()).values().stream().anyMatch(path -> !path.toPath().isAbsolute())) {
            return "data-dirs";
        }
        if (node.getBackupDir().isConfigured() && !((RawPath)node.getBackupDir().get()).toPath().isAbsolute()) {
            return "backup-dir";
        }
        if (node.getLogDir().isConfigured() && !((RawPath)node.getLogDir().get()).toPath().isAbsolute()) {
            return "log-dir";
        }
        if (node.getMetadataDir().isConfigured() && !((RawPath)node.getMetadataDir().get()).toPath().isAbsolute()) {
            return "metadata-dir";
        }
        if (node.getSecurityDir().isConfigured() && !((RawPath)node.getSecurityDir().get()).toPath().isAbsolute()) {
            return "security-dir";
        }
        if (node.getSecurityAuditLogDir().isConfigured() && !((RawPath)node.getSecurityAuditLogDir().get()).toPath().isAbsolute()) {
            return "audit-log-dir";
        }
        return null;
    }
}

