/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.command;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.beust.jcommander.Parameter;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.cli.command.Command;

public class LocalMainCommand
extends Command {
    @Parameter(names={"-verbose", "-v", "--verbose"}, description="Verbose mode. Default: false")
    public boolean verbose = false;

    @Override
    public void run() {
        if (this.verbose) {
            Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
            ConsoleAppender appender = Stream.of("STDERR", "STDOUT", "CONSOLE").map(arg_0 -> ((Logger)rootLogger).getAppender(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
            if (appender == null) {
                throw new IllegalStateException("Logging appender 'STDERR' is missing!");
            }
            PatternLayoutEncoder ple = new PatternLayoutEncoder();
            ple.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} %-5p %c{1}:%L - %msg%n");
            ple.setContext(appender.getContext());
            ple.start();
            appender.setEncoder((Encoder)ple);
            rootLogger.setLevel(Level.TRACE);
            rootLogger.getLoggerContext().getLoggerList().forEach(logger -> logger.setLevel(Level.TRACE));
        }
    }
}

