/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.nomad.TopologyNomadChange;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.dynamic_config.cli.api.converter.OperationType;
import org.terracotta.inet.HostPort;

public abstract class TopologyAction
extends RemoteAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyAction.class);
    protected OperationType operationType = OperationType.NODE;
    protected HostPort destinationHostPort;
    protected boolean force;
    protected Node.Endpoint destination;
    protected Map<Node.Endpoint, LogicalServerState> destinationOnlineNodes;
    protected boolean destinationClusterActivated;
    protected Cluster destinationCluster;

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public void setDestinationHostPort(HostPort destinationHostPort) {
        this.destinationHostPort = destinationHostPort;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    protected void validate() {
        this.destination = this.getEndpoint(this.destinationHostPort);
        this.destinationCluster = this.getUpcomingCluster(this.destination);
        this.destinationOnlineNodes = this.findOnlineRuntimePeers(this.destination);
        this.destinationClusterActivated = this.areAllNodesActivated(this.destinationOnlineNodes.keySet());
        if (!this.destinationCluster.containsNode(this.destination.getNodeUID())) {
            throw new IllegalArgumentException("Wrong destination endpoint: " + this.destination + ". It does not match any node in destination cluster: " + this.destinationCluster.toShapeString());
        }
        if (this.destinationClusterActivated) {
            this.ensureNodesAreEitherActiveOrPassive(this.destinationOnlineNodes);
            this.ensureActivesAreAllOnline(this.destinationCluster, this.destinationOnlineNodes);
        }
    }

    @Override
    public void run() {
        this.validate();
        this.execute();
    }

    protected void execute() {
        Cluster result = this.updateTopology();
        new ClusterValidator(result).validate(this.destinationClusterActivated ? ClusterState.ACTIVATED : ClusterState.CONFIGURING);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated topology:{}{}.", (Object)System.lineSeparator(), (Object)this.toJson(result));
        }
        if (this.destinationClusterActivated) {
            TopologyNomadChange nomadChange = this.buildNomadChange(result);
            this.licenseValidation(this.destination.getHostPort(), nomadChange.getCluster());
            this.onNomadChangeReady(nomadChange);
            this.output.info("Sending the topology change", new Object[0]);
            try {
                this.runTopologyChange(this.destinationCluster, this.destinationOnlineNodes, nomadChange);
            }
            catch (RuntimeException e) {
                this.onNomadChangeFailure(nomadChange, e);
            }
            this.onNomadChangeSuccess(nomadChange);
        } else {
            this.output.info("Sending the topology change", new Object[0]);
            HashSet<Node.Endpoint> allOnlineNodes = new HashSet<Node.Endpoint>(this.getAllOnlineSourceNodes());
            allOnlineNodes.addAll(this.destinationOnlineNodes.keySet());
            this.setUpcomingCluster(allOnlineNodes, result);
        }
        this.output.info("Resulting cluster: " + result.toShapeString(), new Object[0]);
        this.output.info("Command successful!", new Object[0]);
    }

    OperationType getOperationType() {
        return this.operationType;
    }

    protected final void validateLogOrFail(Supplier<Boolean> expectedCondition, String error) {
        if (!expectedCondition.get().booleanValue()) {
            if (this.force) {
                LOGGER.warn("Following validation has been bypassed with the force option:{} - {}", (Object)System.lineSeparator(), (Object)error);
            } else {
                throw new IllegalArgumentException(error);
            }
        }
    }

    protected void onNomadChangeReady(TopologyNomadChange nomadChange) {
    }

    protected void onNomadChangeSuccess(TopologyNomadChange nomadChange) {
    }

    protected void onNomadChangeFailure(TopologyNomadChange nomadChange, RuntimeException error) {
        throw error;
    }

    protected abstract Collection<Node.Endpoint> getAllOnlineSourceNodes();

    protected abstract Cluster updateTopology();

    protected abstract TopologyNomadChange buildNomadChange(Cluster var1);
}

