/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.util.List;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ConfigFormat;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationAction;

public class GetAction
extends ConfigurationAction {
    private boolean wantsRuntimeConfig;
    private ConfigFormat outputFormat = ConfigFormat.CONFIG;

    public GetAction() {
        super(Operation.GET);
    }

    public void setOutputFormat(ConfigFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setRuntimeConfig(boolean wantsRuntimeConfig) {
        this.wantsRuntimeConfig = wantsRuntimeConfig;
    }

    @Override
    public void run() {
        super.validate();
        Cluster cluster = this.wantsRuntimeConfig ? this.getRuntimeCluster(this.node) : this.getUpcomingCluster(this.node);
        TreeMap properties = new TreeMap();
        cluster.toProperties(false, true, true).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put((String)k, (String)v)));
        cluster.toProperties(true, true, true).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put((String)k, (String)v)));
        for (Configuration configuration : this.configurations) {
            List<String> out = properties.entrySet().stream().filter(e -> configuration.matchConfigPropertyKey((String)e.getKey())).map(e -> this.formatOutput((String)e.getKey(), (String)e.getValue(), cluster)).collect(Collectors.toList());
            if (out.isEmpty()) continue;
            out.forEach(s -> this.output.out(s, new Object[0]));
        }
    }

    private String formatOutput(String key, String value, Cluster cluster) {
        StringBuilder sb = new StringBuilder();
        switch (this.outputFormat) {
            case PROPERTIES: {
                sb.append(key);
                break;
            }
            case CONFIG: {
                Configuration c = Configuration.valueOf((String)key);
                if (c.getLevel() == Scope.STRIPE) {
                    sb.append("stripe:").append(((Stripe)cluster.getStripe(c.getStripeId()).get()).getName()).append(":");
                } else if (c.getLevel() == Scope.NODE) {
                    sb.append("node:").append(((Node)((Stripe)cluster.getStripe(c.getStripeId()).get()).getNodes().get(c.getNodeId() - 1)).getName()).append(":");
                }
                sb.append(c.getSetting());
                if (c.getKey() == null) break;
                sb.append(".").append(c.getKey());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format: " + this.outputFormat + ". Supported formats: " + String.join((CharSequence)", ", ConfigFormat.supported()));
            }
        }
        if (this.outputFormat == ConfigFormat.PROPERTIES) {
            // empty if block
        }
        return sb.append("=").append(value).toString();
    }
}

