/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.time.Duration;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.common.struct.Tuple2;
import org.terracotta.diagnostic.client.connection.DiagnosticServices;
import org.terracotta.diagnostic.model.LogicalServerState;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Operation;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Requirement;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.nomad.DynamicConfigNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.MultiSettingNomadChange;
import org.terracotta.dynamic_config.api.model.nomad.SettingNomadChange;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.cli.api.command.ConfigurationAction;

public abstract class ConfigurationMutationAction
extends ConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMutationAction.class);
    protected boolean autoRestart;
    protected Measure<TimeUnit> restartWaitTime = Measure.of((long)120L, (Enum)TimeUnit.SECONDS);
    protected Measure<TimeUnit> restartDelay = Measure.of((long)2L, (Enum)TimeUnit.SECONDS);

    protected ConfigurationMutationAction(Operation operation) {
        super(operation);
    }

    public void setAutoRestart(boolean autoRestart) {
        this.autoRestart = autoRestart;
    }

    public void setRestartWaitTime(Measure<TimeUnit> restartWaitTime) {
        this.restartWaitTime = restartWaitTime;
    }

    public void setRestartDelay(Measure<TimeUnit> restartDelay) {
        this.restartDelay = restartDelay;
    }

    @Override
    public void run() {
        this.validate();
        if (this.configurations.size() == 0) {
            this.output.info("Command successful!", new Object[0]);
            return;
        }
        LOGGER.debug("Validating the new configuration change(s) against the topology of: {}", (Object)this.node);
        Cluster originalCluster = this.getUpcomingCluster(this.node);
        Cluster updatedCluster = originalCluster.clone();
        TreeSet<String> nodesRequiringRestart = new TreeSet<String>();
        TreeSet targetedNodes = new TreeSet();
        for (Configuration c : this.configurations) {
            Collection targets = c.apply((PropertyHolder)updatedCluster);
            targets.stream().filter(o -> o.getScope() == Scope.NODE).map(PropertyHolder::getName).filter(arg_0 -> ((Cluster)originalCluster).containsNode(arg_0)).forEach(name -> {
                targetedNodes.add(name);
                if (c.getSetting().requires(Requirement.NODE_RESTART)) {
                    nodesRequiringRestart.add((String)name);
                }
            });
        }
        if (updatedCluster.equals((Object)originalCluster)) {
            String message = "The requested update will not result in any change to the cluster configuration.";
            this.output.out(message, new Object[0]);
            LOGGER.warn(System.lineSeparator() + "=======================================================================================" + System.lineSeparator() + message + System.lineSeparator() + "=======================================================================================" + System.lineSeparator());
            return;
        }
        Map<Node.Endpoint, LogicalServerState> onlineNodes = this.findOnlineRuntimePeers(this.node);
        LOGGER.debug("Online nodes: {}", onlineNodes);
        boolean allOnlineNodesActivated = this.areAllNodesActivated(onlineNodes.keySet());
        new ClusterValidator(updatedCluster).validate(allOnlineNodesActivated ? ClusterState.ACTIVATED : ClusterState.CONFIGURING);
        if (allOnlineNodesActivated) {
            this.licenseValidation(this.node, updatedCluster);
        }
        TreeSet missingTargetedNodes = new TreeSet(targetedNodes);
        onlineNodes.keySet().stream().map(Node.Endpoint::getNodeName).forEach(missingTargetedNodes::remove);
        if (!missingTargetedNodes.isEmpty()) {
            throw new IllegalStateException("Some nodes that are targeted by the change are not reachable and thus cannot be validated. Please ensure these nodes are online, or remove them from the request: " + ConfigurationMutationAction.toString(missingTargetedNodes));
        }
        LOGGER.debug("New configuration change(s) can be sent");
        if (allOnlineNodesActivated) {
            this.ensureNodesAreEitherActiveOrPassive(onlineNodes);
            if (this.requiresAllNodesAlive()) {
                this.ensurePassivesAreAllOnline(originalCluster, onlineNodes);
            }
            this.ensureActivesAreAllOnline(originalCluster, onlineNodes);
            this.output.info("Applying new configuration change(s) to activated nodes: {}", new Object[]{ConfigurationMutationAction.toString(onlineNodes.keySet())});
            MultiSettingNomadChange changes = this.getNomadChanges(updatedCluster);
            if (!changes.getChanges().isEmpty()) {
                this.runConfigurationChange(updatedCluster, onlineNodes, (DynamicConfigNomadChange)changes);
            }
            if (changes.getChanges().stream().map(SettingNomadChange::getSetting).anyMatch(setting -> setting.requires(Requirement.CLUSTER_RESTART))) {
                this.output.out("Restart required for cluster", new Object[0]);
                if (this.autoRestart) {
                    this.rollingRestart(updatedCluster, onlineNodes.keySet().stream().collect(Collectors.toMap(Node.Endpoint::getNodeName, Function.identity())));
                } else {
                    LOGGER.warn(System.lineSeparator() + "====================================================================" + System.lineSeparator() + "IMPORTANT: A manual restart of the cluster is required to apply the changes" + System.lineSeparator() + "====================================================================" + System.lineSeparator());
                }
            } else {
                long numberOfDifferentSettingsRequiringRestart;
                long numberOfDifferentSettingsToChange = this.configurations.stream().map(Configuration::getSetting).distinct().count();
                if (numberOfDifferentSettingsToChange != (numberOfDifferentSettingsRequiringRestart = this.configurations.stream().map(Configuration::getSetting).distinct().filter(setting -> setting.requires(Requirement.NODE_RESTART)).count())) {
                    for (Node.Endpoint endpoint2 : new LinkedHashSet<Node.Endpoint>(onlineNodes.keySet())) {
                        try {
                            if (!targetedNodes.contains(endpoint2.getNodeName()) || !this.mustBeRestarted(endpoint2)) continue;
                            nodesRequiringRestart.add(endpoint2.getNodeName());
                        }
                        catch (RuntimeException e) {
                            LOGGER.warn("Node: " + endpoint2 + " is not reachable anymore: {}", (Object)e.getMessage(), (Object)e);
                            onlineNodes.remove(endpoint2);
                        }
                    }
                }
                if (!nodesRequiringRestart.isEmpty()) {
                    List addresses = onlineNodes.keySet().stream().filter(endpoint -> nodesRequiringRestart.contains(endpoint.getNodeName())).map(Node.Endpoint::getHostPort).collect(Collectors.toList());
                    this.output.out("Restart required for nodes: {} ", new Object[]{ConfigurationMutationAction.toString(addresses)});
                    if (this.autoRestart) {
                        this.rollingRestart(updatedCluster, onlineNodes.keySet().stream().filter(endpoint -> nodesRequiringRestart.contains(endpoint.getNodeName())).collect(Collectors.toMap(Node.Endpoint::getNodeName, Function.identity())));
                    } else {
                        LOGGER.warn(System.lineSeparator() + "=======================================================================================" + System.lineSeparator() + "IMPORTANT: A manual restart of nodes: " + ConfigurationMutationAction.toString(nodesRequiringRestart) + " is required to apply the changes" + System.lineSeparator() + "=======================================================================================" + System.lineSeparator());
                    }
                }
            }
        } else {
            this.output.info("Applying new configuration change(s) to nodes: {}", new Object[]{ConfigurationMutationAction.toString(onlineNodes.keySet())});
            try (DiagnosticServices diagnosticServices = this.multiDiagnosticServiceProvider.fetchOnlineDiagnosticServices(ConfigurationMutationAction.endpointsToMap(onlineNodes.keySet()));){
                ConfigurationMutationAction.dynamicConfigServices(diagnosticServices).map(Tuple2::getT2).forEach(dynamicConfigService -> dynamicConfigService.setUpcomingCluster(updatedCluster));
            }
        }
        this.output.info("Command successful!", new Object[0]);
    }

    private MultiSettingNomadChange getNomadChanges(Cluster cluster) {
        return new MultiSettingNomadChange(this.configurations.stream().map(configuration -> {
            configuration.validate(this.clusterState, this.operation);
            return SettingNomadChange.fromConfiguration((Configuration)configuration, (Operation)this.operation, (Cluster)cluster);
        }).collect(Collectors.toList()));
    }

    private boolean requiresAllNodesAlive() {
        return this.configurations.stream().map(Configuration::getSetting).anyMatch(setting -> setting.requires(Requirement.CLUSTER_ONLINE));
    }

    private void rollingRestart(Cluster cluster, Map<String, Node.Endpoint> onlineNodesToRestart) {
        LinkedHashSet<Node.Endpoint> cannotRestart = new LinkedHashSet<Node.Endpoint>();
        LinkedList<Node.Endpoint> actives = new LinkedList<Node.Endpoint>();
        LinkedList<Node.Endpoint> others = new LinkedList<Node.Endpoint>();
        for (Stripe stripe : cluster.getStripes()) {
            List onlineNodesPerStripe = onlineNodesToRestart.values().stream().filter(endpoint -> stripe.containsNode(endpoint.getNodeName())).collect(Collectors.toList());
            if (onlineNodesPerStripe.isEmpty()) {
                LOGGER.warn("No node in stripe '{}' seem to be online", (Object)stripe.getName());
                continue;
            }
            if (onlineNodesPerStripe.size() == 1) {
                Node.Endpoint alone = (Node.Endpoint)onlineNodesPerStripe.get(0);
                LOGGER.warn("Unable to restart node: {} in stripe '{}' because this is the only online node", (Object)alone, (Object)stripe.getName());
                cannotRestart.add(alone);
                continue;
            }
            for (Node.Endpoint endpoint2 : onlineNodesPerStripe) {
                LogicalServerState state = LogicalServerState.UNREACHABLE;
                try {
                    state = this.getLogicalServerState(endpoint2);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Node: {} in stripe '{}' is not reachable anymore: {}", new Object[]{endpoint2, stripe.getName(), e.getMessage(), e});
                    cannotRestart.add(endpoint2);
                }
                if (state.isActive()) {
                    actives.add(endpoint2);
                    continue;
                }
                others.add(endpoint2);
            }
        }
        LOGGER.info("Restarting non active nodes: {}...", (Object)ConfigurationMutationAction.toString(others));
        this.restartNodesIfPassives(others, Duration.ofMillis(this.restartWaitTime.getQuantity((Enum)TimeUnit.MILLISECONDS)), Duration.ofMillis(this.restartDelay.getQuantity((Enum)TimeUnit.MILLISECONDS)), EnumSet.of(LogicalServerState.ACTIVE, LogicalServerState.ACTIVE_RECONNECTING, LogicalServerState.PASSIVE));
        LOGGER.info("Restarting active nodes: {}...", (Object)ConfigurationMutationAction.toString(actives));
        this.restartNodesIfActives(actives, Duration.ofMillis(this.restartWaitTime.getQuantity((Enum)TimeUnit.MILLISECONDS)), Duration.ofMillis(this.restartDelay.getQuantity((Enum)TimeUnit.MILLISECONDS)), EnumSet.of(LogicalServerState.ACTIVE, LogicalServerState.ACTIVE_RECONNECTING, LogicalServerState.PASSIVE));
        Stream.concat(actives.stream(), others.stream()).filter(endpoint -> {
            try {
                return this.mustBeRestarted((Node.Endpoint)endpoint);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Node: {} is not reachable anymore: {}", (Object)e.getMessage(), (Object)e);
                return true;
            }
        }).forEach(cannotRestart::add);
        if (!cannotRestart.isEmpty()) {
            LOGGER.warn(System.lineSeparator() + "=======================================================================================" + System.lineSeparator() + "IMPORTANT: A manual restart of nodes: " + ConfigurationMutationAction.toString(cannotRestart) + " will be required to apply the changes" + System.lineSeparator() + "=======================================================================================" + System.lineSeparator());
        }
    }
}

