/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.command;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.terracotta.common.struct.Measure;
import org.terracotta.common.struct.TimeUnit;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.ClusterState;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.service.ClusterFactory;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.api.service.NameGenerator;
import org.terracotta.dynamic_config.api.service.Props;
import org.terracotta.dynamic_config.cli.api.command.RemoteAction;
import org.terracotta.inet.HostPort;

public class ActivateAction
extends RemoteAction {
    private List<HostPort> nodes = Collections.emptyList();
    private Path configPropertiesFile;
    private String clusterName;
    private Path licenseFile;
    private Measure<TimeUnit> restartWaitTime = Measure.of((long)120L, (Enum)TimeUnit.SECONDS);
    private Measure<TimeUnit> restartDelay = Measure.of((long)2L, (Enum)TimeUnit.SECONDS);
    private boolean restrictedActivation;
    private List<Map.Entry<Collection<HostPort>, String>> shape = Collections.emptyList();
    Cluster cluster;

    public void setNodess(List<HostPort> nodes) {
        this.nodes = nodes;
    }

    public void setConfigPropertiesFile(Path configPropertiesFile) {
        this.configPropertiesFile = configPropertiesFile;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setLicenseFile(Path licenseFile) {
        this.licenseFile = licenseFile;
    }

    public void setRestartWaitTime(Measure<TimeUnit> restartWaitTime) {
        this.restartWaitTime = restartWaitTime;
    }

    public void setRestartDelay(Measure<TimeUnit> restartDelay) {
        this.restartDelay = restartDelay;
    }

    public void setRestrictedActivation(boolean restrictedActivation) {
        this.restrictedActivation = restrictedActivation;
    }

    @Override
    public final void run() {
        Collection runtimePeers;
        if (this.shape.isEmpty()) {
            this.cluster = this.loadTopologyFromConfig().orElseGet(() -> this.loadTopologyFromNode().orElseThrow(() -> new IllegalArgumentException("One of node or config properties file must be specified")));
        } else {
            this.cluster = this.getRuntimeCluster(this.shape.get(0).getKey().iterator().next());
            this.cluster.setName(null);
            this.cluster.removeStripes();
            Properties clusterProperties = this.cluster.toProperties(false, false, false);
            this.cluster.setStripes(this.shape.stream().map(entry -> new Stripe().setUID(this.cluster.newUID()).setName((String)entry.getValue()).setNodes(((Collection)entry.getKey()).stream().map(hostPort -> {
                Cluster c = this.getRuntimeCluster((HostPort)hostPort);
                c.setName(null);
                if (c.getNodeCount() != 1) {
                    throw new IllegalArgumentException("Host: " + hostPort + " already contains a topology with 2 nodes or more so it cannot be used in a fast activation");
                }
                Node node = ((Node)c.getSingleNode().get()).setUID(this.cluster.newUID());
                this.cluster.getNodeByName(node.getName()).ifPresent(existing -> {
                    throw new IllegalArgumentException("Host: " + hostPort + " points to a node having the same name of an other node: " + existing);
                });
                c.removeStripes();
                Properties props = c.toProperties(false, false, false);
                if (!clusterProperties.equals(props)) {
                    throw new IllegalArgumentException("Host: " + hostPort + " has been started with cluster settings:\n" + Props.toString((Properties)props) + "\nBut we expected:\n" + Props.toString((Properties)clusterProperties));
                }
                return node;
            }).collect(Collectors.toList()))).collect(Collectors.toList()));
            NameGenerator.assignFriendlyNames((Cluster)this.cluster);
        }
        if (this.clusterName != null) {
            this.cluster.setName(this.clusterName);
        }
        if (this.cluster.getName() == null) {
            throw new IllegalArgumentException("Cluster name is missing");
        }
        new ClusterValidator(this.cluster).validate(ClusterState.ACTIVATED);
        Collection collection = runtimePeers = this.restrictedActivation ? (Collection)this.nodes.stream().map(this::getEndpoint).collect(Collectors.toList()) : this.cluster.determineEndpoints(this.nodes);
        if (this.areAllNodesActivated(runtimePeers)) {
            throw new IllegalStateException("Nodes are already activated: " + ActivateAction.toString(runtimePeers));
        }
        if (!this.restrictedActivation) {
            NameGenerator.assignFriendlyNames((Cluster)this.cluster);
        }
        this.activateNodes(runtimePeers, this.cluster, this.licenseFile, this.restartDelay, this.restartWaitTime);
        this.output.info("Command successful!", new Object[0]);
    }

    private Optional<Cluster> loadTopologyFromConfig() {
        return Optional.ofNullable(this.configPropertiesFile).map(path -> {
            ClusterFactory clusterCreator = new ClusterFactory();
            Cluster cluster = clusterCreator.create(this.configPropertiesFile);
            this.output.info("Cluster topology loaded and validated from configuration file: " + cluster.toShapeString(), new Object[0]);
            return cluster;
        });
    }

    private Optional<Cluster> loadTopologyFromNode() {
        return this.nodes.stream().map(hostPort -> {
            Cluster cluster = this.getUpcomingCluster((HostPort)hostPort);
            this.output.info("Cluster topology loaded from: " + hostPort + ": " + cluster.toShapeString(), new Object[0]);
            return cluster;
        }).findFirst();
    }

    Cluster getCluster() {
        return this.cluster;
    }

    public void setShape(List<Map.Entry<Collection<HostPort>, String>> shape) {
        this.shape = shape;
    }
}

