/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.cli.api.output;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import org.slf4j.helpers.MessageFormatter;
import org.terracotta.dynamic_config.cli.api.output.OutputService;

public class InMemoryOutputService
implements OutputService {
    private final Queue<String> lines = new ConcurrentLinkedQueue<String>();

    public InMemoryOutputService() {
        this(Collections.emptyList());
    }

    public InMemoryOutputService(List<String> buffer) {
        this.lines.addAll(buffer);
    }

    public void clear() {
        this.lines.clear();
    }

    public Stream<String> lines() {
        return this.lines.stream();
    }

    public String toString() {
        return "memory";
    }

    @Override
    public void out(String format, Object ... args) {
        StringTokenizer st = new StringTokenizer(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage(), "\n\r");
        while (st.hasMoreTokens()) {
            this.lines.offer(st.nextToken());
        }
    }
}

