/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.org.junit.rules.TemporaryFolder;
import org.terracotta.testing.ExtendedTestRule;

public class TmpDir
extends ExtendedTestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmpDir.class);
    private final Path parent;
    private final boolean autoClean;
    private TemporaryFolder delegate;
    private Path root;

    public TmpDir() {
        this(null, true);
    }

    public TmpDir(Path parent) {
        this(parent, true);
    }

    public TmpDir(boolean autoClean) {
        this(null, autoClean);
    }

    public TmpDir(Path parent, boolean autoClean) {
        this.parent = parent;
        this.autoClean = autoClean;
    }

    @Override
    protected void before(Description description) throws Throwable {
        if (this.parent != null) {
            Files.createDirectories(this.parent, new FileAttribute[0]);
        }
        this.delegate = TemporaryFolder.builder().parentFolder(this.parent == null ? null : this.parent.toFile()).assureDeletion().build();
        this.delegate.create();
        if (description.getMethodName() == null) {
            this.root = this.delegate.newFolder(description.getTestClass().getSimpleName()).toPath();
            LOGGER.info("Temporary directory for {}: {}", (Object)description.getTestClass().getSimpleName(), (Object)this.root);
        } else {
            this.root = this.delegate.newFolder(new String[]{description.getTestClass().getSimpleName(), description.getMethodName()}).toPath();
            LOGGER.info("Temporary directory for {}#{}: {}", new Object[]{description.getTestClass().getSimpleName(), description.getMethodName(), this.root});
        }
    }

    @Override
    protected void after(Description description) throws Throwable {
        if (this.autoClean || this.empty()) {
            this.delegate.delete();
        }
    }

    public Path getRoot() {
        return this.root;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean empty() {
        try (Stream<Path> walk = Files.walk(this.root, new FileVisitOption[0]);){
            boolean bl = walk.allMatch(path -> Files.isDirectory(path, new LinkOption[0]));
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

