/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.testing.JavaBinary;

public class JavaTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaTool.class);

    public static Stream<Process> processes() {
        if (JavaBinary.JPS == null) {
            return Stream.empty();
        }
        return Stream.of(JavaBinary.exec(JavaBinary.JPS, new String[0]).split("\\r?\\n")).filter(line -> !line.trim().isEmpty()).filter(line -> !line.toLowerCase(Locale.US).contains("jstack")).filter(line -> !line.toLowerCase(Locale.US).contains("jps")).filter(line -> !line.toLowerCase(Locale.US).contains("process information unavailable")).map(line -> {
            int sep = line.indexOf(" ");
            String name = (sep == -1 ? "unknown" : line.substring(sep + 1)).trim();
            return new Process(Long.parseLong(line.substring(0, sep)), name.isEmpty() ? "unknown" : name);
        });
    }

    public static Optional<Dump> threadDump(Process process, Duration timeout) {
        LOGGER.info("Taking thread dump of process: {} (timeout: {})", (Object)process, (Object)(timeout == null ? "none" : timeout.toMillis() + "ms"));
        String dump = JavaBinary.exec(timeout, JavaBinary.JSTACK, "-l", "" + process.pid);
        if (dump.contains("No such process")) {
            LOGGER.warn("No such process: {}", (Object)process);
            return Optional.empty();
        }
        return Optional.of(new Dump(process, dump));
    }

    public static Stream<Dump> threadDumps(Duration timeout) {
        return JavaTool.processes().map(p -> JavaTool.threadDump(p, timeout)).filter(Optional::isPresent).map(Optional::get);
    }

    public static void threadDumps(Path outputDir, Duration timeout) {
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        JavaTool.threadDumps(timeout).forEach(dump -> dump.writeTo(outputDir.resolve("thread-dump-" + ((Dump)dump).process.pid + "-" + ((Dump)dump).process.processName.replaceAll("\\W", "_") + ".log")));
    }

    public static void memoryDump(Process process, Path output, Duration timeout) {
        LOGGER.info("Taking memory dump of process: {} (timeout: {})", (Object)process, (Object)(timeout == null ? "none" : timeout.toMillis() + "ms"));
        JavaBinary.exec(timeout, JavaBinary.JMAP, "-dump:format=b,file=" + output, "" + process.pid);
    }

    public static void memoryDumps(Path outputDir, Duration timeout) {
        try {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        JavaTool.processes().forEach(p -> JavaTool.memoryDump(p, outputDir.resolve("memory-dump-" + ((Process)p).pid + "-" + ((Process)p).processName.replaceAll("\\W", "_") + ".bin"), timeout));
    }

    public static class Process {
        private final long pid;
        private final String processName;

        private Process(long pid, String processName) {
            this.pid = pid;
            this.processName = processName == null || processName.trim().isEmpty() ? "unknown" : processName.trim();
        }

        public long getPid() {
            return this.pid;
        }

        public String getProcessName() {
            return this.processName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Process that = (Process)o;
            return this.pid == that.pid;
        }

        public int hashCode() {
            return Objects.hash(this.pid);
        }

        public String toString() {
            return this.pid + " (" + this.processName + ")";
        }
    }

    public static class Dump {
        private final Process process;
        private final String dump;

        private Dump(Process process, String dump) {
            this.process = process;
            this.dump = Objects.requireNonNull(dump);
        }

        public Process getProcess() {
            return this.process;
        }

        public String getDump() {
            return this.dump;
        }

        public void writeTo(Path out) {
            LOGGER.info("Saving dump of process: {} to: {}", (Object)this.process, (Object)out);
            try {
                Files.write(out, this.dump.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

