/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBinary {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaBinary.class);
    private static final boolean WIN = System.getProperty("os.name", "").toLowerCase().contains("win");
    public static final Path JPS = JavaBinary.find("jps").orElse(null);
    public static final Path JSTACK = JavaBinary.find("jstack").orElse(null);
    public static final Path JMAP = JavaBinary.find("jmap").orElse(null);

    public static Optional<Path> find(String name) {
        return Stream.of(System.getProperty("java.home"), System.getenv("JAVA_HOME")).filter(Objects::nonNull).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(home -> Stream.of(home, home.getParent())).map(home -> home.resolve("bin").resolve(JavaBinary.bin(name))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    public static String exec(Path bin, String ... params) {
        CharSequence[] cmd = new String[params.length + 1];
        cmd[0] = bin.toString();
        System.arraycopy(params, 0, cmd, 1, params.length);
        try {
            LOGGER.trace("exec({})", (Object)String.join((CharSequence)" ", cmd));
            Process process = new ProcessBuilder((String[])cmd).redirectErrorStream(true).start();
            process.waitFor();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InputStream is = process.getInputStream();){
                int b;
                while ((b = is.read()) != -1) {
                    out.write(b);
                }
            }
            return out.toString("UTF-8");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String exec(final Duration timeout, Path bin, String ... params) {
        Process process;
        long delayMs = Math.max(timeout == null ? 0L : timeout.toMillis(), 0L);
        CharSequence[] cmd = new String[params.length + 1];
        cmd[0] = bin.toString();
        System.arraycopy(params, 0, cmd, 1, params.length);
        LOGGER.trace("exec(timeout={}ms, cmd={})", (Object)delayMs, (Object)String.join((CharSequence)" ", cmd));
        try {
            process = new ProcessBuilder((String[])cmd).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Timer timer = null;
        if (delayMs > 0L) {
            timer = new Timer();
            timer.schedule(new TimerTask((String[])cmd, out){
                final /* synthetic */ String[] val$cmd;
                final /* synthetic */ ByteArrayOutputStream val$out;
                {
                    this.val$cmd = stringArray;
                    this.val$out = byteArrayOutputStream;
                }

                @Override
                public void run() {
                    if (process.isAlive()) {
                        String message = "Timeout after " + timeout.getSeconds() + " seconds when trying to execute: " + String.join((CharSequence)" ", this.val$cmd);
                        try {
                            this.val$out.write(message.getBytes(StandardCharsets.UTF_8));
                        }
                        catch (IOException e) {
                            LOGGER.warn(message, (Throwable)e);
                        }
                        process.destroyForcibly();
                    }
                }
            }, timeout.toMillis());
        }
        try (InputStream is = process.getInputStream();){
            int b;
            while ((b = is.read()) != -1) {
                out.write(b);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read process input stream: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            process.waitFor();
            String e = out.toString("UTF-8");
            return e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (timer != null) {
                timer.cancel();
            }
        }
    }

    public static String bin(String name) {
        return WIN ? name + ".exe" : name;
    }

    static {
        if (JPS == null || JSTACK == null || JMAP == null) {
            LOGGER.warn("Unable to find jps or jstack or jmap location using java.home ({}) or JAVA_HOME ({}))", (Object)System.getProperty("java.home"), (Object)System.getenv("JAVA_HOME"));
        } else {
            LOGGER.trace("jps: {}", (Object)JPS);
            LOGGER.trace("jstack: {}", (Object)JSTACK);
            LOGGER.trace("jmap: {}", (Object)JMAP);
        }
    }
}

