/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.testing;

import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ExceptionMatcher
extends TypeSafeMatcher<Closure> {
    private static final CustomMatcher<String> ANY_MESSAGE = new CustomMatcher<String>("ANY MESSAGE"){

        public boolean matches(Object item) {
            return true;
        }
    };
    private static final CustomMatcher<? super Class<? extends Throwable>> ANY_CAUSE = new CustomMatcher<Class<? extends Throwable>>("ANY CAUSE"){

        public boolean matches(Object item) {
            return true;
        }
    };
    private final Matcher<? super Class<? extends Throwable>> typeMatcher;
    private Matcher<? super String> messageMatcher = ANY_MESSAGE;
    private Matcher<? super Class<? extends Throwable>> causeMatcher = ANY_CAUSE;
    private Throwable failure;
    private boolean debug;

    private ExceptionMatcher(Matcher<? super Class<? extends Throwable>> typeMatcher) {
        this.typeMatcher = Objects.requireNonNull(typeMatcher);
    }

    public void describeTo(Description description) {
        this.typeMatcher.describeTo(description);
        if (this.messageMatcher != ANY_MESSAGE) {
            description.appendText(" with message ");
            this.messageMatcher.describeTo(description);
        }
        if (this.causeMatcher != ANY_CAUSE) {
            description.appendText(" with cause ");
            this.causeMatcher.describeTo(description);
        }
    }

    protected boolean matchesSafely(Closure item) {
        try {
            item.run();
            return false;
        }
        catch (Throwable e) {
            boolean match;
            if (this.debug) {
                e.printStackTrace();
            }
            this.failure = e;
            boolean bl = match = this.typeMatcher.matches((Object)e) && this.messageMatcher.matches((Object)e.getMessage()) && this.causeMatcher.matches((Object)e.getCause());
            if (!match) {
                e.printStackTrace();
            }
            return match;
        }
    }

    protected void describeMismatchSafely(Closure item, Description mismatchDescription) {
        if (this.failure != null) {
            super.describeMismatchSafely((Object)new ToStringClosure(this.failure.toString()), mismatchDescription);
        } else {
            super.describeMismatchSafely((Object)new ToStringClosure("no exception was thrown"), mismatchDescription);
        }
    }

    public static ExceptionMatcher throwing() {
        return ExceptionMatcher.throwing((Matcher<? super Class<? extends Throwable>>)CoreMatchers.instanceOf(Throwable.class));
    }

    public static ExceptionMatcher throwing(Matcher<? super Class<? extends Throwable>> err) {
        return new ExceptionMatcher(err);
    }

    public ExceptionMatcher debug() {
        this.debug = true;
        return this;
    }

    public ExceptionMatcher andMessage(Matcher<? super String> messageMatcher) {
        this.messageMatcher = Objects.requireNonNull(messageMatcher);
        return this;
    }

    public ExceptionMatcher andCause(Matcher<? super Class<? extends Throwable>> causeMatcher) {
        this.causeMatcher = Objects.requireNonNull(causeMatcher);
        return this;
    }

    @FunctionalInterface
    public static interface Closure {
        public void run() throws Throwable;
    }

    private static class ToStringClosure
    implements Closure {
        private final String toString;

        public ToStringClosure(String toString) {
            this.toString = toString;
        }

        @Override
        public void run() {
        }

        public String toString() {
            return this.toString;
        }
    }
}

