/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.file.lock;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.terracotta.persistence.sanskrit.Owner;
import org.terracotta.persistence.sanskrit.file.lock.CloseLock;
import org.terracotta.persistence.sanskrit.file.lock.LockManager;
import org.terracotta.persistence.sanskrit.file.lock.MuxLock;

public class MuxLockManager
implements LockManager {
    private final List<LockManager> lockManagers;

    public MuxLockManager(LockManager ... lockManagers) {
        this(Arrays.asList(lockManagers));
    }

    private MuxLockManager(List<LockManager> lockManagers) {
        this.lockManagers = lockManagers;
    }

    @Override
    public CloseLock lockOrFail(Path path) throws IOException {
        try (Owner<MuxLock, IOException> lockOwner = Owner.own(new MuxLock(), IOException.class);){
            for (LockManager lockManager : this.lockManagers) {
                CloseLock lock = lockManager.lockOrFail(path);
                lockOwner.borrow().addLock(lock);
            }
            CloseLock closeLock = lockOwner.release();
            return closeLock;
        }
    }
}

