/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.file.lock;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.terracotta.persistence.sanskrit.file.lock.CloseLock;

public class MuxLock
implements CloseLock {
    private final Deque<CloseLock> locks = new ArrayDeque<CloseLock>();

    public void addLock(CloseLock lock) {
        this.locks.push(lock);
    }

    @Override
    public void close() throws IOException {
        CloseLock lock;
        IOException error = new IOException("Failed to close locks");
        while ((lock = this.locks.peek()) != null) {
            try {
                lock.close();
            }
            catch (IOException e) {
                error.addSuppressed(e);
            }
            this.locks.pop();
        }
        if (error.getSuppressed().length > 0) {
            throw error;
        }
    }
}

