/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.file.lock;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.persistence.sanskrit.file.lock.CloseLock;
import org.terracotta.persistence.sanskrit.file.lock.LockManager;

public class LocalLockManager
implements LockManager {
    private static final Set<Path> LOCKS = ConcurrentHashMap.newKeySet();

    @Override
    public CloseLock lockOrFail(Path path) throws IOException {
        if (LOCKS.add(path)) {
            return new LocalLock(path);
        }
        throw new IOException("Local lock already held: " + path);
    }

    private static class LocalLock
    implements CloseLock {
        private final Path path;

        public LocalLock(Path path) {
            this.path = path;
        }

        @Override
        public void close() {
            if (!LOCKS.remove(this.path)) {
                throw new AssertionError((Object)("Attempt to unlock when lock not held: " + this.path));
            }
        }
    }
}

