/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.file.lock;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import org.terracotta.persistence.sanskrit.Owner;
import org.terracotta.persistence.sanskrit.file.lock.CloseLock;

public class FileCloseLock
implements CloseLock {
    private final Channel channel;
    private final FileLock fileLock;

    public FileCloseLock(Channel channel, FileLock fileLock) {
        this.channel = channel;
        this.fileLock = fileLock;
    }

    @Override
    public void close() throws IOException {
        try (Owner<Channel, IOException> channelOwner = Owner.own(this.channel, IOException.class);){
            Owner<FileLock, IOException> fileLockOwner = Owner.own(this.fileLock, IOException.class);
            Throwable throwable = null;
            if (fileLockOwner != null) {
                if (throwable != null) {
                    try {
                        fileLockOwner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fileLockOwner.close();
                }
            }
        }
    }
}

