/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.file;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.terracotta.persistence.sanskrit.DirectoryLock;
import org.terracotta.persistence.sanskrit.FileData;
import org.terracotta.persistence.sanskrit.FilesystemDirectory;
import org.terracotta.persistence.sanskrit.file.FileChannelFileData;
import org.terracotta.persistence.sanskrit.file.lock.CloseLock;
import org.terracotta.persistence.sanskrit.file.lock.FileLockManager;
import org.terracotta.persistence.sanskrit.file.lock.LocalLockManager;
import org.terracotta.persistence.sanskrit.file.lock.LockManager;
import org.terracotta.persistence.sanskrit.file.lock.MuxLockManager;

public class FileBasedFilesystemDirectory
implements FilesystemDirectory {
    private static final LockManager LOCK_MANAGER = new MuxLockManager(new LocalLockManager(), new FileLockManager());
    private final Path directory;

    public FileBasedFilesystemDirectory(Path directory) {
        this.directory = directory;
    }

    @Override
    public DirectoryLock lock() throws IOException {
        CloseLock lock = LOCK_MANAGER.lockOrFail(this.directory);
        return lock::close;
    }

    @Override
    public FileData create(String filename, boolean canExist) throws IOException {
        Path path = this.directory.resolve(filename);
        StandardOpenOption createOption = canExist ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW;
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, createOption);
        return new FileChannelFileData(channel);
    }

    @Override
    public FileData getFileData(String filename) throws IOException {
        Path path = this.directory.resolve(filename);
        if (!path.toFile().exists()) {
            return null;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Attempted to read file but it is a directory: " + filename);
        }
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
        return new FileChannelFileData(channel);
    }

    @Override
    public void delete(String filename) throws IOException {
        Path path = this.directory.resolve(filename);
        org.terracotta.utilities.io.Files.deleteIfExists((Path)path);
    }

    @Override
    public void backup(String filename) throws IOException {
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss.SSS"));
        Path path = this.directory.resolve(filename);
        if (path.toFile().exists()) {
            Path dest = path.resolveSibling("backup-" + filename + "-" + time);
            org.terracotta.utilities.io.Files.relocate((Path)path, (Path)dest, (CopyOption[])new CopyOption[0]);
        }
    }
}

