/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit.change;

import java.util.ArrayList;
import java.util.List;
import org.terracotta.persistence.sanskrit.SanskritObject;
import org.terracotta.persistence.sanskrit.change.AddLongSanskritChange;
import org.terracotta.persistence.sanskrit.change.AddObjectSanskritChange;
import org.terracotta.persistence.sanskrit.change.AddStringSanskritChange;
import org.terracotta.persistence.sanskrit.change.MuxSanskritChange;
import org.terracotta.persistence.sanskrit.change.SanskritChange;
import org.terracotta.persistence.sanskrit.change.UnsetKeySanskritChange;

public class SanskritChangeBuilder {
    private List<SanskritChange> changes = new ArrayList<SanskritChange>();

    public static SanskritChangeBuilder newChange() {
        return new SanskritChangeBuilder();
    }

    private SanskritChangeBuilder() {
    }

    public SanskritChangeBuilder setString(String key, String value) {
        this.changes.add(new AddStringSanskritChange(key, value));
        return this;
    }

    public SanskritChangeBuilder setLong(String key, long value) {
        this.changes.add(new AddLongSanskritChange(key, value));
        return this;
    }

    public SanskritChangeBuilder setObject(String key, SanskritObject value) {
        this.changes.add(new AddObjectSanskritChange(key, value));
        return this;
    }

    public SanskritChangeBuilder removeKey(String key) {
        this.changes.add(new UnsetKeySanskritChange(key));
        return this;
    }

    public SanskritChange build() {
        return new MuxSanskritChange(this.changes);
    }
}

