/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.terracotta.persistence.sanskrit.CopyUtils;
import org.terracotta.persistence.sanskrit.MutableSanskritObject;
import org.terracotta.persistence.sanskrit.ObjectMapperSupplier;
import org.terracotta.persistence.sanskrit.SanskritObject;
import org.terracotta.persistence.sanskrit.SanskritVisitor;

public class SanskritObjectImpl
implements MutableSanskritObject {
    private final ObjectNode mappings;
    private final ObjectMapperSupplier objectMapperSupplier;

    public SanskritObjectImpl(ObjectMapperSupplier objectMapperSupplier) {
        this(objectMapperSupplier, objectMapperSupplier.getObjectMapper().createObjectNode());
    }

    SanskritObjectImpl(ObjectMapperSupplier objectMapperSupplier, ObjectNode node) {
        this.objectMapperSupplier = objectMapperSupplier;
        this.mappings = node;
    }

    @Override
    public void setString(String key, String value) {
        this.mappings.put(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.mappings.put(key, value);
    }

    @Override
    public void setObject(String key, SanskritObject object) {
        this.mappings.set(key, (JsonNode)CopyUtils.makeCopy((ObjectMapperSupplier)this.objectMapperSupplier, (SanskritObject)object).mappings);
    }

    @Override
    public <T> void setExternal(String key, T o, String version) {
        if (o instanceof SanskritObject) {
            this.setObject(key, (SanskritObject)o);
        } else {
            this.mappings.set(key, o instanceof JsonNode ? (JsonNode)o : this.objectMapperSupplier.getObjectMapper(version).valueToTree(o));
        }
    }

    @Override
    public void accept(SanskritVisitor visitor) {
        Iterator fields = this.mappings.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isTextual()) {
                visitor.setString(key, value.textValue());
                continue;
            }
            if (value.isLong()) {
                visitor.setLong(key, value.longValue());
                continue;
            }
            if (value.isObject()) {
                visitor.setObject(key, new SanskritObjectImpl(this.objectMapperSupplier, (ObjectNode)value));
                continue;
            }
            visitor.setExternal(key, value, null);
        }
    }

    @Override
    public <T> T getObject(String key, Class<T> type, String version) {
        JsonNode jsonNode = this.mappings.get(key);
        if (jsonNode == null) {
            return null;
        }
        if (type.isInstance(jsonNode)) {
            return type.cast(jsonNode);
        }
        try {
            return type.cast(this.objectMapperSupplier.getObjectMapper(version).treeToValue((TreeNode)jsonNode, type));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getString(String key) {
        return Optional.ofNullable(this.mappings.get(key)).map(TextNode.class::cast).map(TextNode::textValue).orElse(null);
    }

    @Override
    public Long getLong(String key) {
        return Optional.ofNullable(this.mappings.get(key)).map(NumericNode.class::cast).map(NumericNode::longValue).orElse(null);
    }

    @Override
    public SanskritObject getObject(String key) {
        return Optional.ofNullable(this.mappings.get(key)).map(ObjectNode.class::cast).map(node -> new SanskritObjectImpl(this.objectMapperSupplier, (ObjectNode)node)).orElse(null);
    }

    @Override
    public void removeKey(String key) {
        this.mappings.remove(key);
    }
}

