/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import org.terracotta.persistence.sanskrit.MutableSanskritObject;
import org.terracotta.persistence.sanskrit.Sanskrit;
import org.terracotta.persistence.sanskrit.SanskritException;
import org.terracotta.persistence.sanskrit.SanskritObject;
import org.terracotta.persistence.sanskrit.change.SanskritChange;

public class PersistentFailSanskrit
implements Sanskrit {
    private final Sanskrit underlying;
    private volatile Exception failure;

    public PersistentFailSanskrit(Sanskrit underlying) {
        this.underlying = underlying;
    }

    @Override
    public void close() throws SanskritException {
        try {
            this.underlying.close();
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public String getString(String key) throws SanskritException {
        this.failCheck();
        try {
            return this.underlying.getString(key);
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public Long getLong(String key) throws SanskritException {
        this.failCheck();
        try {
            return this.underlying.getLong(key);
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public SanskritObject getObject(String key) throws SanskritException {
        this.failCheck();
        try {
            return this.underlying.getObject(key);
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public void applyChange(SanskritChange change) throws SanskritException {
        this.failCheck();
        try {
            this.underlying.applyChange(change);
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    @Override
    public MutableSanskritObject newMutableSanskritObject() {
        return this.underlying.newMutableSanskritObject();
    }

    @Override
    public void reset() throws SanskritException {
        try {
            this.underlying.reset();
        }
        catch (Exception e) {
            this.failure = e;
            throw e;
        }
    }

    private void failCheck() throws SanskritException {
        if (this.failure != null) {
            throw new SanskritException("No longer operational due to earlier error", this.failure);
        }
    }
}

