/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

public class Owner<T extends AutoCloseable, E extends Exception>
implements AutoCloseable {
    private final T underlying;
    private final Class<E> exceptionClass;
    private boolean released;

    public static <T extends AutoCloseable, E extends Exception> Owner<T, E> own(T underlying, Class<E> exceptionClass) {
        return new Owner<T, E>(underlying, exceptionClass);
    }

    private Owner(T underlying, Class<E> exceptionClass) {
        this.underlying = underlying;
        this.exceptionClass = exceptionClass;
    }

    public T borrow() {
        return this.underlying;
    }

    public T release() {
        this.released = true;
        return this.underlying;
    }

    @Override
    public void close() throws E {
        if (!this.released && this.underlying != null) {
            try {
                this.underlying.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (this.exceptionClass.isAssignableFrom(e.getClass())) {
                    throw this.uncheckedExceptionCast(e);
                }
                throw new RuntimeException("Unexpected exception type. Expected: " + this.exceptionClass + ", found: " + e.getClass(), e);
            }
        }
    }

    private E uncheckedExceptionCast(Exception e) {
        return (E)e;
    }
}

