/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface ObjectMapperSupplier {
    default public ObjectMapper getObjectMapper() {
        return this.getObjectMapper(null);
    }

    public ObjectMapper getObjectMapper(String var1);

    public String getCurrentVersion();

    public static ObjectMapperSupplier notVersioned(final ObjectMapper objectMapper) {
        return new ObjectMapperSupplier(){

            @Override
            public ObjectMapper getObjectMapper(String version) {
                return objectMapper;
            }

            @Override
            public String getCurrentVersion() {
                return "";
            }
        };
    }

    public static ObjectMapperSupplierBuilder versioned(ObjectMapper current, String version) {
        return new ObjectMapperSupplierBuilder(current, version);
    }

    public static class ObjectMapperSupplierBuilder
    implements ObjectMapperSupplier {
        private final ObjectMapper current;
        private final String version;
        private final Map<String, ObjectMapper> deprecated = new HashMap<String, ObjectMapper>();

        public ObjectMapperSupplierBuilder(ObjectMapper current, String version) {
            this.current = current;
            this.version = version;
        }

        public ObjectMapperSupplierBuilder withVersions(ObjectMapper objectMapper, String ... versions) {
            for (String version : versions) {
                this.deprecated.put(version, objectMapper);
            }
            return this;
        }

        @Override
        public ObjectMapper getObjectMapper(String version) {
            return version == null ? this.current : Optional.ofNullable(this.deprecated.get(version)).orElseThrow(() -> new IllegalArgumentException("Unsupported version: " + version));
        }

        @Override
        public String getCurrentVersion() {
            return this.version;
        }
    }
}

