/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkableLineParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkableLineParser.class);
    public static final String LS = "\n";
    public static final String CR = "\r";
    private final InputStream input;
    private long position;
    private long mark;

    public MarkableLineParser(InputStream input) {
        this.input = input;
    }

    public Stream<String> lines() {
        return StreamSupport.stream(new LineParsingSpliterator(), false);
    }

    public void mark() {
        this.mark = this.position;
    }

    public long getMark() {
        return this.mark;
    }

    private class LineParsingSpliterator
    implements Spliterator<String> {
        private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();

        private LineParsingSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            try {
                StringBuilder sb = new StringBuilder();
                do {
                    Character nextCharacter;
                    if ((nextCharacter = this.readNextCharacter()) == null) {
                        return false;
                    }
                    sb.append(nextCharacter);
                } while (!this.endsWithLineSeparator(sb, MarkableLineParser.LS));
                String line = this.withoutLineSeparator(sb);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("parsed: {}", (Object)line.replace(MarkableLineParser.CR, "\\r").replace(MarkableLineParser.LS, "\\n"));
                }
                action.accept(line);
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Character readNextCharacter() throws IOException {
            CoderResult decodeResult;
            CharBuffer nextCharacter;
            ByteBuffer nextBytes = ByteBuffer.allocate(3);
            while (true) {
                int b = MarkableLineParser.this.input.read();
                MarkableLineParser.this.position++;
                if (b == -1) {
                    return null;
                }
                nextBytes.put((byte)b);
                nextBytes.flip();
                nextCharacter = CharBuffer.allocate(1);
                decodeResult = this.decoder.decode(nextBytes, nextCharacter, false);
                if (decodeResult.isError()) {
                    decodeResult.throwException();
                }
                if (nextCharacter.position() != 0) break;
                nextBytes.compact();
            }
            if (decodeResult.isOverflow()) {
                throw new AssertionError((Object)"Cannot decode more than one character at a time");
            }
            return Character.valueOf(nextCharacter.get(0));
        }

        private boolean endsWithLineSeparator(StringBuilder sb, String eol) {
            if (sb.length() < eol.length()) {
                return false;
            }
            char[] lastChars = new char[eol.length()];
            sb.getChars(sb.length() - eol.length(), sb.length(), lastChars, 0);
            String suffix = new String(lastChars);
            return eol.equals(suffix);
        }

        private String withoutLineSeparator(StringBuilder sb) {
            sb.delete(sb.length() - MarkableLineParser.LS.length(), sb.length());
            if (this.endsWithLineSeparator(sb, MarkableLineParser.CR)) {
                sb.delete(sb.length() - MarkableLineParser.CR.length(), sb.length());
            }
            return sb.toString();
        }

        @Override
        public Spliterator<String> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

