/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.persistence.sanskrit;

import java.io.IOException;
import org.terracotta.persistence.sanskrit.DirectoryLock;
import org.terracotta.persistence.sanskrit.MutableSanskritObject;
import org.terracotta.persistence.sanskrit.Owner;
import org.terracotta.persistence.sanskrit.Sanskrit;
import org.terracotta.persistence.sanskrit.SanskritException;
import org.terracotta.persistence.sanskrit.SanskritObject;
import org.terracotta.persistence.sanskrit.change.SanskritChange;

public class LockReleasingSanskrit
implements Sanskrit {
    private final Sanskrit underlying;
    private final DirectoryLock lock;

    public LockReleasingSanskrit(Sanskrit underlying, DirectoryLock lock) {
        this.underlying = underlying;
        this.lock = lock;
    }

    @Override
    public void close() throws SanskritException {
        try (Owner<DirectoryLock, IOException> lockOwner = Owner.own(this.lock, IOException.class);){
            Owner<Sanskrit, SanskritException> sanskritOwner = Owner.own(this.underlying, SanskritException.class);
            Throwable throwable = null;
            if (sanskritOwner != null) {
                if (throwable != null) {
                    try {
                        sanskritOwner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    sanskritOwner.close();
                }
            }
        }
        catch (IOException e) {
            throw new SanskritException(e);
        }
    }

    @Override
    public String getString(String key) throws SanskritException {
        return this.underlying.getString(key);
    }

    @Override
    public Long getLong(String key) throws SanskritException {
        return this.underlying.getLong(key);
    }

    @Override
    public SanskritObject getObject(String key) throws SanskritException {
        return this.underlying.getObject(key);
    }

    @Override
    public void applyChange(SanskritChange change) throws SanskritException {
        this.underlying.applyChange(change);
    }

    @Override
    public MutableSanskritObject newMutableSanskritObject() {
        return this.underlying.newMutableSanskritObject();
    }

    @Override
    public void reset() throws SanskritException {
        this.underlying.reset();
    }
}

